/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.xml.jackson.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.jackson.codec.JacksonFeatures;
import io.micronaut.jackson.codec.JacksonMediaTypeCodec;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Named;
import jakarta.inject.Singleton;

@Named(value="xml")
@Singleton
@BootstrapContextCompatible
public class XmlMediaTypeCodec
extends JacksonMediaTypeCodec {
    public static final String CONFIGURATION_QUALIFIER = "xml";

    public XmlMediaTypeCodec(@Named(value="xml") ObjectMapper xmlMapper, ApplicationConfiguration applicationConfiguration, @Named(value="xml") @Nullable CodecConfiguration codecConfiguration) {
        super(xmlMapper, applicationConfiguration, codecConfiguration, MediaType.APPLICATION_XML_TYPE);
    }

    public JacksonMediaTypeCodec cloneWithFeatures(JacksonFeatures jacksonFeatures) {
        ObjectMapper objectMapper = this.getObjectMapper().copy();
        jacksonFeatures.getDeserializationFeatures().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
        jacksonFeatures.getSerializationFeatures().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
        return new XmlMediaTypeCodec(objectMapper, this.applicationConfiguration, this.codecConfiguration);
    }
}

