/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.baggage.processor;

import io.opentelemetry.contrib.baggage.processor.BaggageLogRecordProcessor;
import io.opentelemetry.contrib.baggage.processor.BaggageSpanProcessor;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizer;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.util.List;

public class BaggageProcessorCustomizer
implements AutoConfigurationCustomizerProvider {
    public void customize(AutoConfigurationCustomizer autoConfigurationCustomizer) {
        autoConfigurationCustomizer.addTracerProviderCustomizer((sdkTracerProviderBuilder, config) -> {
            BaggageProcessorCustomizer.addSpanProcessor(sdkTracerProviderBuilder, config);
            return sdkTracerProviderBuilder;
        }).addLoggerProviderCustomizer((sdkLoggerProviderBuilder, config) -> {
            BaggageProcessorCustomizer.addLogRecordProcessor(sdkLoggerProviderBuilder, config);
            return sdkLoggerProviderBuilder;
        });
    }

    private static void addSpanProcessor(SdkTracerProviderBuilder sdkTracerProviderBuilder, ConfigProperties config) {
        List keys = config.getList("otel.java.experimental.span-attributes.copy-from-baggage.include");
        if (keys.isEmpty()) {
            return;
        }
        sdkTracerProviderBuilder.addSpanProcessor((SpanProcessor)BaggageProcessorCustomizer.createBaggageSpanProcessor(keys));
    }

    static BaggageSpanProcessor createBaggageSpanProcessor(List<String> keys) {
        if (keys.size() == 1 && keys.get(0).equals("*")) {
            return BaggageSpanProcessor.allowAllBaggageKeys();
        }
        return new BaggageSpanProcessor(keys::contains);
    }

    private static void addLogRecordProcessor(SdkLoggerProviderBuilder sdkLoggerProviderBuilder, ConfigProperties config) {
        List keys = config.getList("otel.java.experimental.log-attributes.copy-from-baggage.include");
        if (keys.isEmpty()) {
            return;
        }
        sdkLoggerProviderBuilder.addLogRecordProcessor((LogRecordProcessor)BaggageProcessorCustomizer.createBaggageLogRecordProcessor(keys));
    }

    static BaggageLogRecordProcessor createBaggageLogRecordProcessor(List<String> keys) {
        if (keys.size() == 1 && keys.get(0).equals("*")) {
            return BaggageLogRecordProcessor.allowAllBaggageKeys();
        }
        return new BaggageLogRecordProcessor(keys::contains);
    }
}

