/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.resources;

import com.google.auto.service.AutoService;
import io.opentelemetry.instrumentation.resources.AttributeProvider;
import io.opentelemetry.instrumentation.resources.AttributeResourceProvider;
import io.opentelemetry.instrumentation.resources.internal.ManifestResourceExtractor;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ServiceAttributes;
import java.util.Optional;
import java.util.function.Supplier;

@AutoService(value={ResourceProvider.class})
public final class ManifestResourceProvider
extends AttributeResourceProvider<Resource> {
    public ManifestResourceProvider() {
        this(() -> new ManifestResourceExtractor().extract());
    }

    ManifestResourceProvider(final Supplier<Resource> resourceSupplier) {
        super(new AttributeProvider<Resource>(){

            @Override
            public Optional<Resource> readData() {
                return Optional.of((Resource)resourceSupplier.get());
            }

            @Override
            public void registerAttributes(AttributeProvider.Builder<Resource> builder) {
                builder.add(ServiceAttributes.SERVICE_NAME, r -> Optional.ofNullable((String)r.getAttribute(ServiceAttributes.SERVICE_NAME))).add(ServiceAttributes.SERVICE_VERSION, r -> Optional.ofNullable((String)r.getAttribute(ServiceAttributes.SERVICE_VERSION)));
            }
        });
    }

    public int order() {
        return 300;
    }
}

