/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.callback;

import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.core.ConnectionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.core.ValueStore;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.Connection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import reactor.util.annotation.Nullable;

final class DefaultConnectionInfo
implements ConnectionInfo {
    private static final AtomicIntegerFieldUpdater<DefaultConnectionInfo> TRANSACTION_COUNT_INCREMENTER = AtomicIntegerFieldUpdater.newUpdater(DefaultConnectionInfo.class, "transactionCount");
    private static final AtomicIntegerFieldUpdater<DefaultConnectionInfo> COMMIT_COUNT_INCREMENTER = AtomicIntegerFieldUpdater.newUpdater(DefaultConnectionInfo.class, "commitCount");
    private static final AtomicIntegerFieldUpdater<DefaultConnectionInfo> ROLLBACK_COUNT_INCREMENTER = AtomicIntegerFieldUpdater.newUpdater(DefaultConnectionInfo.class, "rollbackCount");
    private Connection originalConnection;
    private String connectionId;
    private AtomicBoolean isClosed = new AtomicBoolean();
    private volatile int transactionCount = 0;
    private volatile int commitCount = 0;
    private volatile int rollbackCount = 0;
    private ValueStore valueStore = ValueStore.create();

    DefaultConnectionInfo() {
    }

    public void setOriginalConnection(Connection originalConnection) {
        Assert.requireNonNull(originalConnection, "originalConnection must not be null");
        this.originalConnection = originalConnection;
    }

    public void setConnectionId(String connectionId) {
        Assert.requireNonNull(connectionId, "connectionId must not be null");
        this.connectionId = connectionId;
    }

    @Override
    public void setClosed(boolean closed) {
        this.isClosed.set(closed);
    }

    @Override
    @Nullable
    public Connection getOriginalConnection() {
        return this.originalConnection;
    }

    @Override
    @Nullable
    public String getConnectionId() {
        return this.connectionId;
    }

    @Override
    public void incrementTransactionCount() {
        TRANSACTION_COUNT_INCREMENTER.incrementAndGet(this);
    }

    @Override
    public void incrementCommitCount() {
        COMMIT_COUNT_INCREMENTER.incrementAndGet(this);
    }

    @Override
    public void incrementRollbackCount() {
        ROLLBACK_COUNT_INCREMENTER.incrementAndGet(this);
    }

    @Override
    public int getTransactionCount() {
        return this.transactionCount;
    }

    @Override
    public int getCommitCount() {
        return this.commitCount;
    }

    @Override
    public int getRollbackCount() {
        return this.rollbackCount;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public ValueStore getValueStore() {
        return this.valueStore;
    }
}

