/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.sender;

import java.util.function.Function;
import org.apache.kafka.clients.producer.Producer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kafka.sender.KafkaOutbound;
import reactor.kafka.sender.SenderOptions;
import reactor.kafka.sender.SenderRecord;
import reactor.kafka.sender.SenderResult;
import reactor.kafka.sender.TransactionManager;
import reactor.kafka.sender.internals.DefaultKafkaSender;
import reactor.kafka.sender.internals.ProducerFactory;

public interface KafkaSender<K, V> {
    public static <K, V> KafkaSender<K, V> create(SenderOptions<K, V> options) {
        return new DefaultKafkaSender<K, V>(ProducerFactory.INSTANCE, options);
    }

    public static <K, V> KafkaSender<K, V> create(ProducerFactory factory, SenderOptions<K, V> options) {
        return new DefaultKafkaSender<K, V>(factory, options);
    }

    public <T> Flux<SenderResult<T>> send(Publisher<? extends SenderRecord<K, V, T>> var1);

    public <T> Flux<Flux<SenderResult<T>>> sendTransactionally(Publisher<? extends Publisher<? extends SenderRecord<K, V, T>>> var1);

    public TransactionManager transactionManager();

    public KafkaOutbound<K, V> createOutbound();

    public <T> Mono<T> doOnProducer(Function<Producer<K, V>, ? extends T> var1);

    public void close();
}

