/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.sender;

import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.kafka.KafkaClientMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.producer.Producer;
import reactor.kafka.sender.SenderOptions;

public class MicrometerProducerListener
implements SenderOptions.ProducerListener {
    private final MeterRegistry meterRegistry;
    private final List<Tag> tags;
    private final Map<String, KafkaClientMetrics> metrics = new HashMap<String, KafkaClientMetrics>();

    public MicrometerProducerListener(MeterRegistry meterRegistry) {
        this(meterRegistry, Collections.emptyList());
    }

    public MicrometerProducerListener(MeterRegistry meterRegistry, List<Tag> tags) {
        this.meterRegistry = meterRegistry;
        this.tags = tags;
    }

    @Override
    public synchronized void producerAdded(String id, Producer<?, ?> producer) {
        if (!this.metrics.containsKey(id)) {
            ArrayList<Tag> producerTags = new ArrayList<Tag>(this.tags);
            producerTags.add((Tag)new ImmutableTag("reactor-kafka.id", id));
            this.metrics.put(id, new KafkaClientMetrics(producer, producerTags));
            this.metrics.get(id).bindTo(this.meterRegistry);
        }
    }

    @Override
    public synchronized void producerRemoved(String id, Producer<?, ?> producer) {
        KafkaClientMetrics removed = this.metrics.remove(id);
        if (removed != null) {
            removed.close();
        }
    }
}

