/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent.config;

import java.time.Duration;
import java.time.temporal.ChronoUnit;

public final class IntervalParser {
    public static Duration parse(String str) throws NumberFormatException {
        long amount;
        ChronoUnit unit;
        if (str.endsWith("ms")) {
            unit = ChronoUnit.MILLIS;
            amount = Long.parseLong(str.substring(0, str.length() - 2));
        } else if (str.endsWith("us")) {
            unit = ChronoUnit.MICROS;
            amount = Long.parseLong(str.substring(0, str.length() - 2));
        } else if (str.endsWith("s")) {
            unit = ChronoUnit.SECONDS;
            amount = Long.parseLong(str.substring(0, str.length() - 1));
        } else if (Character.isDigit(str.charAt(str.length() - 1))) {
            unit = ChronoUnit.NANOS;
            amount = Long.parseLong(str);
        } else {
            throw new NumberFormatException("Cannot parse interval " + str);
        }
        if (amount <= 0L) {
            throw new NumberFormatException("Interval must be positive, but " + str + " given");
        }
        return Duration.of(amount, unit);
    }
}

