/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.dynamodb.runtime;

import io.quarkus.arc.DefaultBean;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;

@ApplicationScoped
public class DynamodbClientProducer {
    private final DynamoDbClient syncClient;
    private final DynamoDbAsyncClient asyncClient;

    DynamodbClientProducer(Instance<DynamoDbClientBuilder> syncClientBuilderInstance, Instance<DynamoDbAsyncClientBuilder> asyncClientBuilderInstance) {
        this.syncClient = syncClientBuilderInstance.isResolvable() ? (DynamoDbClient)((DynamoDbClientBuilder)syncClientBuilderInstance.get()).build() : null;
        this.asyncClient = asyncClientBuilderInstance.isResolvable() ? (DynamoDbAsyncClient)((DynamoDbAsyncClientBuilder)asyncClientBuilderInstance.get()).build() : null;
    }

    @DefaultBean
    @Produces
    @ApplicationScoped
    public DynamoDbClient client() {
        if (this.syncClient == null) {
            throw new IllegalStateException("The DynamoDbClient is required but has not been detected/configured.");
        }
        return this.syncClient;
    }

    @DefaultBean
    @Produces
    @ApplicationScoped
    public DynamoDbAsyncClient asyncClient() {
        if (this.asyncClient == null) {
            throw new IllegalStateException("The DynamoDbAsyncClient is required but has not been detected/configured.");
        }
        return this.asyncClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.syncClient != null) {
            this.syncClient.close();
        }
        if (this.asyncClient != null) {
            this.asyncClient.close();
        }
    }
}

