/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.impl.ComputingCache;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.FieldDescriptors;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class AnnotationLiteralGenerator
extends AbstractGenerator {
    static final String ANNOTATION_LITERAL_SUFFIX = "_AnnotationLiteral";
    static final String SHARED_SUFFIX = "_Shared";
    private static final Logger LOGGER = Logger.getLogger(AnnotationLiteralGenerator.class);

    Collection<ResourceOutput.Resource> generate(String name, BeanDeployment beanDeployment, ComputingCache<AnnotationLiteralProcessor.Key, AnnotationLiteralProcessor.Literal> annotationLiteralsCache) {
        ArrayList<ResourceOutput.Resource> resources = new ArrayList<ResourceOutput.Resource>();
        annotationLiteralsCache.forEachEntry((key, literal) -> {
            ResourceClassOutput classOutput = new ResourceClassOutput(literal.isApplicationClass);
            AnnotationLiteralGenerator.createSharedAnnotationLiteral(classOutput, key, literal);
            resources.addAll(classOutput.getResources());
        });
        return resources;
    }

    static void createSharedAnnotationLiteral(ClassOutput classOutput, AnnotationLiteralProcessor.Key key, AnnotationLiteralProcessor.Literal literal) {
        String signature = String.format("Ljavax/enterprise/util/AnnotationLiteral<L%1$s;>;L%1$s;", key.annotationName.toString().replace('.', '/'));
        String generatedName = literal.className.replace('.', '/');
        ClassCreator annotationLiteral = ClassCreator.builder().classOutput(classOutput).className(generatedName).superClass(AnnotationLiteral.class).interfaces(new String[]{key.annotationName.toString()}).signature(signature).build();
        MethodCreator constructor = annotationLiteral.getMethodCreator("<init>", (Object)"V", literal.constructorParams.stream().map(m -> m.returnType().name().toString()).toArray());
        constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(AnnotationLiteral.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
        ListIterator<MethodInfo> iterator = literal.constructorParams.listIterator();
        while (iterator.hasNext()) {
            MethodInfo param = iterator.next();
            String returnType = param.returnType().name().toString();
            annotationLiteral.getFieldCreator(param.name(), returnType).setModifiers(18);
            constructor.writeInstanceField(FieldDescriptor.of((String)annotationLiteral.getClassName(), (String)param.name(), (String)returnType), constructor.getThis(), constructor.getMethodParam(iterator.previousIndex()));
            MethodCreator value = (MethodCreator)annotationLiteral.getMethodCreator(param.name(), returnType, new String[0]).setModifiers(1);
            value.returnValue(value.readInstanceField(FieldDescriptor.of((String)annotationLiteral.getClassName(), (String)param.name(), (String)returnType), value.getThis()));
        }
        constructor.returnValue(null);
        annotationLiteral.close();
        LOGGER.debugf("Shared annotation literal generated: %s", (Object)literal.className);
    }

    static void createAnnotationLiteral(ClassOutput classOutput, ClassInfo annotationClass, AnnotationInstance annotationInstance, String literalName) {
        Map annotationValues = annotationInstance.values().stream().collect(Collectors.toMap(AnnotationValue::name, Function.identity()));
        String signature = String.format("Ljavax/enterprise/util/AnnotationLiteral<L%1$s;>;L%1$s;", annotationClass.name().toString().replace('.', '/'));
        String generatedName = literalName.replace('.', '/');
        ClassCreator annotationLiteral = ClassCreator.builder().classOutput(classOutput).className(generatedName).superClass(AnnotationLiteral.class).interfaces(new String[]{annotationClass.name().toString()}).signature(signature).build();
        for (MethodInfo method : annotationClass.methods()) {
            if (method.name().equals("<clinit>") || method.name().equals("<init>")) continue;
            MethodCreator valueMethod = annotationLiteral.getMethodCreator(MethodDescriptor.of((MethodInfo)method));
            AnnotationValue value = (AnnotationValue)annotationValues.get(method.name());
            if (value == null) {
                value = method.defaultValue();
            }
            if (value == null) {
                throw new IllegalStateException(String.format("Value is not set for %s.%s(). Most probably an older version of Jandex was used to index an application dependency. Make sure that Jandex 2.1+ is used.", method.declaringClass().name(), method.name()));
            }
            valueMethod.returnValue(AnnotationLiteralGenerator.loadValue((BytecodeCreator)valueMethod, value, annotationClass, method));
        }
        annotationLiteral.close();
        LOGGER.debugf("Annotation literal generated: %s", (Object)literalName);
    }

    static ResultHandle loadValue(BytecodeCreator valueMethod, AnnotationValue value, ClassInfo annotationClass, MethodInfo method) {
        ResultHandle retValue;
        switch (value.kind()) {
            case BOOLEAN: {
                retValue = valueMethod.load(value.asBoolean());
                break;
            }
            case STRING: {
                retValue = valueMethod.load(value.asString());
                break;
            }
            case BYTE: {
                retValue = valueMethod.load(value.asByte());
                break;
            }
            case SHORT: {
                retValue = valueMethod.load(value.asShort());
                break;
            }
            case LONG: {
                retValue = valueMethod.load(value.asLong());
                break;
            }
            case INTEGER: {
                retValue = valueMethod.load(value.asInt());
                break;
            }
            case FLOAT: {
                retValue = valueMethod.load(value.asFloat());
                break;
            }
            case DOUBLE: {
                retValue = valueMethod.load(value.asDouble());
                break;
            }
            case CHARACTER: {
                retValue = valueMethod.load(value.asChar());
                break;
            }
            case CLASS: {
                retValue = valueMethod.loadClass(value.asClass().toString());
                break;
            }
            case ARRAY: {
                retValue = AnnotationLiteralGenerator.arrayValue(value, valueMethod, method, annotationClass);
                break;
            }
            case ENUM: {
                retValue = valueMethod.readStaticField(FieldDescriptor.of((String)value.asEnumType().toString(), (String)value.asEnum(), (String)value.asEnumType().toString()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported value: " + value);
            }
        }
        return retValue;
    }

    static ResultHandle arrayValue(AnnotationValue value, BytecodeCreator valueMethod, MethodInfo method, ClassInfo annotationClass) {
        ResultHandle retValue;
        switch (value.componentKind()) {
            case CLASS: {
                Type[] classArray = value.asClassArray();
                retValue = valueMethod.newArray(AnnotationLiteralGenerator.componentType(method), valueMethod.load(classArray.length));
                for (int i = 0; i < classArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.loadClass(classArray[i].name().toString()));
                }
                break;
            }
            case STRING: {
                String[] stringArray = value.asStringArray();
                retValue = valueMethod.newArray(AnnotationLiteralGenerator.componentType(method), valueMethod.load(stringArray.length));
                for (int i = 0; i < stringArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(stringArray[i]));
                }
                break;
            }
            case SHORT: {
                short[] shortArray = value.asShortArray();
                retValue = valueMethod.newArray(AnnotationLiteralGenerator.componentType(method), valueMethod.load(shortArray.length));
                for (int i = 0; i < shortArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(shortArray[i]));
                }
                break;
            }
            case INTEGER: {
                int[] intArray = value.asIntArray();
                retValue = valueMethod.newArray(AnnotationLiteralGenerator.componentType(method), valueMethod.load(intArray.length));
                for (int i = 0; i < intArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(intArray[i]));
                }
                break;
            }
            case LONG: {
                long[] longArray = value.asLongArray();
                retValue = valueMethod.newArray(AnnotationLiteralGenerator.componentType(method), valueMethod.load(longArray.length));
                for (int i = 0; i < longArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(longArray[i]));
                }
                break;
            }
            case BYTE: {
                byte[] byteArray = value.asByteArray();
                retValue = valueMethod.newArray(AnnotationLiteralGenerator.componentType(method), valueMethod.load(byteArray.length));
                for (int i = 0; i < byteArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(byteArray[i]));
                }
                break;
            }
            case CHARACTER: {
                char[] charArray = value.asCharArray();
                retValue = valueMethod.newArray(AnnotationLiteralGenerator.componentType(method), valueMethod.load(charArray.length));
                for (int i = 0; i < charArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(charArray[i]));
                }
                break;
            }
            case FLOAT: {
                float[] floatArray = value.asFloatArray();
                retValue = valueMethod.newArray(AnnotationLiteralGenerator.componentType(method), valueMethod.load(floatArray.length));
                for (int i = 0; i < floatArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(floatArray[i]));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleArray = value.asDoubleArray();
                retValue = valueMethod.newArray(AnnotationLiteralGenerator.componentType(method), valueMethod.load(doubleArray.length));
                for (int i = 0; i < doubleArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(doubleArray[i]));
                }
                break;
            }
            default: {
                DotName componentName;
                AnnotationInstance nonbinding;
                if (value.componentKind() != AnnotationValue.Kind.UNKNOWN && ((nonbinding = method.annotation(DotNames.NONBINDING)) == null || nonbinding.target().kind() != AnnotationTarget.Kind.METHOD)) {
                    LOGGER.warnf("Unsupported array component type %s on %s - literal returns an empty array", (Object)method, (Object)annotationClass);
                }
                retValue = DotNames.CLASS.equals((Object)(componentName = AnnotationLiteralGenerator.componentTypeName(method))) ? valueMethod.readStaticField(FieldDescriptors.ANNOTATION_LITERALS_EMPTY_CLASS_ARRAY) : (DotNames.STRING.equals((Object)componentName) ? valueMethod.readStaticField(FieldDescriptors.ANNOTATION_LITERALS_EMPTY_STRING_ARRAY) : (PrimitiveType.LONG.name().equals((Object)componentName) ? valueMethod.readStaticField(FieldDescriptors.ANNOTATION_LITERALS_EMPTY_LONG_ARRAY) : (PrimitiveType.INT.name().equals((Object)componentName) ? valueMethod.readStaticField(FieldDescriptors.ANNOTATION_LITERALS_EMPTY_INT_ARRAY) : valueMethod.newArray(componentName.toString(), valueMethod.load(0)))));
            }
        }
        return retValue;
    }

    static String componentType(MethodInfo method) {
        return AnnotationLiteralGenerator.componentTypeName(method).toString();
    }

    static DotName componentTypeName(MethodInfo method) {
        ArrayType arrayType = method.returnType().asArrayType();
        return arrayType.component().name();
    }

    static String generatedSharedName(DotName annotationName) {
        String nameToUse = AnnotationLiteralGenerator.isJavaLang(annotationName.toString()) ? AbstractGenerator.DEFAULT_PACKAGE + annotationName.withoutPackagePrefix() : annotationName.toString();
        return nameToUse + SHARED_SUFFIX + ANNOTATION_LITERAL_SUFFIX;
    }

    private static boolean isJavaLang(String s) {
        return s.startsWith("java.lang");
    }

    static String generatedLocalName(String targetPackage, String simpleName, String hash) {
        return (AnnotationLiteralGenerator.isJavaLang(targetPackage) ? AbstractGenerator.DEFAULT_PACKAGE : targetPackage) + "." + simpleName + hash + ANNOTATION_LITERAL_SUFFIX;
    }
}

