/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.QualifierConfigurator;
import io.quarkus.gizmo.MethodCreator;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.enterprise.event.TransactionPhase;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public final class ObserverConfigurator
implements Consumer<AnnotationInstance> {
    final Consumer<ObserverConfigurator> consumer;
    DotName beanClass;
    Type observedType;
    final Set<AnnotationInstance> observedQualifiers;
    int priority;
    boolean isAsync;
    TransactionPhase transactionPhase;
    Consumer<MethodCreator> notifyConsumer;

    public ObserverConfigurator(Consumer<ObserverConfigurator> consumer) {
        this.consumer = consumer;
        this.observedQualifiers = new HashSet<AnnotationInstance>();
        this.priority = 2500;
        this.isAsync = false;
        this.transactionPhase = TransactionPhase.IN_PROGRESS;
    }

    public ObserverConfigurator beanClass(DotName beanClass) {
        this.beanClass = beanClass;
        return this;
    }

    public ObserverConfigurator observedType(Class<?> observedType) {
        this.observedType = Type.create((DotName)DotName.createSimple((String)observedType.getName()), (Type.Kind)Type.Kind.CLASS);
        return this;
    }

    public ObserverConfigurator observedType(Type observedType) {
        this.observedType = observedType;
        return this;
    }

    public ObserverConfigurator addQualifier(Class<? extends Annotation> annotationClass) {
        return this.addQualifier(DotName.createSimple((String)annotationClass.getName()));
    }

    public ObserverConfigurator addQualifier(DotName annotationName) {
        return this.addQualifier(AnnotationInstance.create((DotName)annotationName, null, (AnnotationValue[])new AnnotationValue[0]));
    }

    public ObserverConfigurator addQualifier(AnnotationInstance qualifier) {
        this.observedQualifiers.add(qualifier);
        return this;
    }

    public QualifierConfigurator<ObserverConfigurator> addQualifier() {
        return new QualifierConfigurator<ObserverConfigurator>(this);
    }

    public ObserverConfigurator priority(int priority) {
        this.priority = priority;
        return this;
    }

    public ObserverConfigurator async(boolean value) {
        this.isAsync = value;
        return this;
    }

    public ObserverConfigurator transactionPhase(TransactionPhase transactionPhase) {
        this.transactionPhase = transactionPhase;
        return this;
    }

    public ObserverConfigurator notify(Consumer<MethodCreator> notifyConsumer) {
        this.notifyConsumer = notifyConsumer;
        return this;
    }

    public void done() {
        if (this.beanClass == null) {
            throw new IllegalStateException("Observer bean class must be set!");
        }
        if (this.observedType == null) {
            throw new IllegalStateException("Observed type must be set!");
        }
        if (this.notifyConsumer == null) {
            throw new IllegalStateException("Bytecode generator for notify() method must be set!");
        }
        this.consumer.accept(this);
    }

    @Override
    public void accept(AnnotationInstance qualifier) {
        this.addQualifier(qualifier);
    }
}

