/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.bcextensions.AnnotationInfoImpl;
import io.quarkus.arc.processor.bcextensions.FieldInfoImpl;
import io.quarkus.arc.processor.bcextensions.ParameterInfoImpl;
import io.quarkus.arc.processor.bcextensions.TypeImpl;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.DeclarationInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.util.Collection;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MutableAnnotationOverlay;

class InjectionPointInfoImpl
implements jakarta.enterprise.inject.build.compatible.spi.InjectionPointInfo {
    private final IndexView jandexIndex;
    private final MutableAnnotationOverlay annotationOverlay;
    private final InjectionPointInfo arcInjectionPointInfo;

    InjectionPointInfoImpl(IndexView jandexIndex, MutableAnnotationOverlay annotationOverlay, InjectionPointInfo arcInjectionPointInfo) {
        this.jandexIndex = jandexIndex;
        this.annotationOverlay = annotationOverlay;
        this.arcInjectionPointInfo = arcInjectionPointInfo;
    }

    public Type type() {
        return TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlay, this.arcInjectionPointInfo.getRequiredType());
    }

    public Collection<AnnotationInfo> qualifiers() {
        return this.arcInjectionPointInfo.getRequiredQualifiers().stream().map(it -> new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, (AnnotationInstance)it)).toList();
    }

    public DeclarationInfo declaration() {
        if (this.arcInjectionPointInfo.isField()) {
            FieldInfo jandexField = this.arcInjectionPointInfo.getAnnotationTarget().asField();
            return new FieldInfoImpl(this.jandexIndex, this.annotationOverlay, jandexField);
        }
        if (this.arcInjectionPointInfo.isParam()) {
            return new ParameterInfoImpl(this.jandexIndex, this.annotationOverlay, this.arcInjectionPointInfo.getAnnotationTarget().asMethodParameter());
        }
        throw new IllegalStateException("Unknown injection point: " + this.arcInjectionPointInfo);
    }
}

