/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.attribute.StackMapFrameInfo;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.If;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ConstantDescs;
import java.util.ListIterator;
import java.util.function.BiConsumer;

final class RelZero
extends Item {
    private final Item a;
    private final If.Kind kind;

    RelZero(Expr a, If.Kind kind) {
        super(ConstantDescs.CD_boolean);
        this.kind = kind;
        this.a = (Item)a;
        if (a.typeKind() == TypeKind.REFERENCE && kind.if_acmp == null) {
            throw new IllegalStateException("Invalid comparison for reference types");
        }
    }

    Item input() {
        return this.a;
    }

    @Override
    protected void forEachDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
        this.a.process(itr, op);
    }

    If.Kind kind() {
        return this.kind;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        Label true_ = cb.newLabel();
        Label end = cb.newLabel();
        smb.pop();
        switch (this.a.typeKind().asLoadable()) {
            case INT: {
                this.kind.if_.accept(cb, true_);
                smb.wroteCode();
                break;
            }
            case REFERENCE: {
                this.kind.if_acmpnull.accept(cb, true_);
                smb.wroteCode();
                break;
            }
            case LONG: {
                cb.lconst_0();
                cb.lcmp();
                cb.iconst_1();
                cb.iand();
                smb.push((StackMapFrameInfo.VerificationTypeInfo)StackMapFrameInfo.SimpleVerificationTypeInfo.INTEGER);
                smb.wroteCode();
                return;
            }
            case FLOAT: {
                cb.fconst_0();
                cb.fcmpg();
                cb.iconst_1();
                cb.iand();
                smb.push((StackMapFrameInfo.VerificationTypeInfo)StackMapFrameInfo.SimpleVerificationTypeInfo.INTEGER);
                smb.wroteCode();
                return;
            }
            case DOUBLE: {
                cb.dconst_0();
                cb.dcmpg();
                cb.iconst_1();
                cb.iand();
                smb.push((StackMapFrameInfo.VerificationTypeInfo)StackMapFrameInfo.SimpleVerificationTypeInfo.INTEGER);
                smb.wroteCode();
                return;
            }
            default: {
                throw Assert.impossibleSwitchCase((Object)((Object)this.a.typeKind().asLoadable()));
            }
        }
        cb.iconst_0();
        cb.goto_(end);
        cb.labelBinding(true_);
        smb.addFrameInfo(cb);
        cb.iconst_1();
        smb.wroteCode();
        smb.push((StackMapFrameInfo.VerificationTypeInfo)StackMapFrameInfo.SimpleVerificationTypeInfo.INTEGER);
        cb.labelBinding(end);
        smb.addFrameInfo(cb);
    }
}

