/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.deployment;

import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmo2Adaptor;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.FieldVar;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.InstanceFieldVar;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.This;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.creator.TryCreator;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.hibernate.validator.spi.BeanValidationAnnotationsBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.security.Authenticated;
import io.quarkus.security.PermissionsAllowed;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.RequireBodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.RouteDescriptionBuildItem;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.quarkus.vertx.http.runtime.HttpCompression;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.quarkus.vertx.web.Route;
import io.quarkus.vertx.web.deployment.AnnotatedRouteFilterBuildItem;
import io.quarkus.vertx.web.deployment.AnnotatedRouteHandlerBuildItem;
import io.quarkus.vertx.web.deployment.DotNames;
import io.quarkus.vertx.web.deployment.HandlerDescriptor;
import io.quarkus.vertx.web.deployment.Methods;
import io.quarkus.vertx.web.runtime.RouteHandler;
import io.quarkus.vertx.web.runtime.RouteMatcher;
import io.quarkus.vertx.web.runtime.RoutingExchangeImpl;
import io.quarkus.vertx.web.runtime.UniFailureCallback;
import io.quarkus.vertx.web.runtime.VertxWebRecorder;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.mutiny.core.http.HttpServerRequest;
import io.vertx.mutiny.core.http.HttpServerResponse;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.enterprise.context.ContextNotActiveException;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;
import org.jboss.logging.Logger;

class ReactiveRoutesProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)ReactiveRoutesProcessor.class.getName());
    private static final String HANDLER_SUFFIX = "_RouteHandler";
    private static final String VALUE_PATH = "path";
    private static final String VALUE_REGEX = "regex";
    private static final String VALUE_PRODUCES = "produces";
    private static final String VALUE_CONSUMES = "consumes";
    private static final String VALUE_METHODS = "methods";
    private static final String VALUE_ORDER = "order";
    private static final String VALUE_TYPE = "type";
    private static final String SLASH = "/";
    private static final DotName ROLES_ALLOWED = DotName.createSimple((String)RolesAllowed.class.getName());
    private static final DotName AUTHENTICATED = DotName.createSimple((String)Authenticated.class.getName());
    private static final DotName DENY_ALL = DotName.createSimple((String)DenyAll.class.getName());
    private static final DotName PERMISSIONS_ALLOWED = DotName.createSimple((String)PermissionsAllowed.class.getName());
    private static final List<ParameterInjector> PARAM_INJECTORS = ReactiveRoutesProcessor.initParamInjectors();
    private static final Pattern PATH_PARAM_PATTERN = Pattern.compile("[a-zA-Z_0-9]+");
    private static final List<DotName> TYPES_IGNORED_FOR_REFLECTION = Arrays.asList(DotName.STRING_NAME, DotNames.BUFFER, DotNames.JSON_ARRAY, DotNames.JSON_OBJECT);

    ReactiveRoutesProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.REACTIVE_ROUTES);
    }

    @BuildStep
    void unremovableBeans(BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassAnnotation((DotName)DotNames.ROUTE));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassAnnotation((DotName)DotNames.ROUTES));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassAnnotation((DotName)DotNames.ROUTE_FILTER));
    }

    @BuildStep
    void validateBeanDeployment(BeanArchiveIndexBuildItem beanArchive, ValidationPhaseBuildItem validationPhase, TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<AnnotatedRouteHandlerBuildItem> routeHandlerBusinessMethods, BuildProducer<AnnotatedRouteFilterBuildItem> routeFilterBusinessMethods, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors, VertxHttpBuildTimeConfig httpBuildTimeConfig) {
        AnnotationStore annotationStore = (AnnotationStore)validationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : validationPhase.getContext().beans().classBeans()) {
            ClassInfo beanClass = ((AnnotationTarget)bean.getTarget().get()).asClass();
            AnnotationInstance routeBaseAnnotation = beanClass.declaredAnnotation(DotNames.ROUTE_BASE);
            for (MethodInfo method : beanClass.methods()) {
                AnnotationInstance filterAnnotation;
                AnnotationInstance routesAnnotation;
                if (method.isSynthetic() || Modifier.isStatic(method.flags()) || method.name().equals("<init>")) continue;
                LinkedList<AnnotationInstance> routes = new LinkedList<AnnotationInstance>();
                AnnotationInstance routeAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, DotNames.ROUTE);
                if (routeAnnotation != null) {
                    this.validateRouteMethod(bean, method, transformedAnnotations, beanArchive.getIndex(), routeAnnotation);
                    routes.add(routeAnnotation);
                }
                if (routes.isEmpty() && (routesAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, DotNames.ROUTES)) != null) {
                    for (AnnotationInstance annotation : routesAnnotation.value().asNestedArray()) {
                        this.validateRouteMethod(bean, method, transformedAnnotations, beanArchive.getIndex(), annotation);
                        routes.add(annotation);
                    }
                }
                if (!routes.isEmpty()) {
                    boolean alwaysAuthenticateRoute;
                    LOGGER.debugf("Found route handler business method %s declared on %s", (Object)method, (Object)bean);
                    HttpCompression compression = HttpCompression.UNDEFINED;
                    if (annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.COMPRESSED)) {
                        compression = HttpCompression.ON;
                    }
                    if (annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.UNCOMPRESSED)) {
                        if (compression == HttpCompression.ON) {
                            errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException(String.format("@Compressed and @Uncompressed cannot be both declared on business method %s declared on %s", method, bean))}));
                        } else {
                            compression = HttpCompression.OFF;
                        }
                    }
                    boolean blocking = annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.BLOCKING);
                    if (!httpBuildTimeConfig.auth().proactive() && !blocking) {
                        DotName returnTypeName = method.returnType().name();
                        boolean possiblySynchronousResponse = !returnTypeName.equals((Object)DotNames.UNI) && !returnTypeName.equals((Object)DotNames.MULTI) && !returnTypeName.equals((Object)DotNames.COMPLETION_STAGE);
                        boolean hasRbacAnnotationThatRequiresAuth = annotationStore.hasAnnotation((AnnotationTarget)method, ROLES_ALLOWED) || annotationStore.hasAnnotation((AnnotationTarget)method, AUTHENTICATED) || annotationStore.hasAnnotation((AnnotationTarget)method, PERMISSIONS_ALLOWED) || annotationStore.hasAnnotation((AnnotationTarget)method, DENY_ALL);
                        alwaysAuthenticateRoute = possiblySynchronousResponse && hasRbacAnnotationThatRequiresAuth;
                    } else {
                        alwaysAuthenticateRoute = false;
                    }
                    routeHandlerBusinessMethods.produce((BuildItem)new AnnotatedRouteHandlerBuildItem(bean, method, routes, routeBaseAnnotation, blocking, compression, alwaysAuthenticateRoute));
                }
                if ((filterAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, DotNames.ROUTE_FILTER)) == null) continue;
                if (!routes.isEmpty()) {
                    errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException(String.format("@Route and @RouteFilter cannot be declared on business method %s declared on %s", method, bean))}));
                    continue;
                }
                this.validateRouteFilterMethod(bean, method);
                routeFilterBusinessMethods.produce((BuildItem)new AnnotatedRouteFilterBuildItem(bean, method, filterAnnotation));
                LOGGER.debugf("Found route filter business method %s declared on %s", (Object)method, (Object)bean);
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void replaceDefaultAuthFailureHandler(VertxWebRecorder recorder, Capabilities capabilities, BuildProducer<FilterBuildItem> filterBuildItemBuildProducer) {
        if (capabilities.isMissing("io.quarkus.resteasy.reactive")) {
            filterBuildItemBuildProducer.produce((BuildItem)new FilterBuildItem(recorder.addAuthFailureHandler(), 199));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void addAdditionalRoutes(VertxWebRecorder recorder, List<AnnotatedRouteHandlerBuildItem> routeHandlerBusinessMethods, List<AnnotatedRouteFilterBuildItem> routeFilterBusinessMethods, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<GeneratedResourceBuildItem> generatedResource, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BodyHandlerBuildItem bodyHandler, BuildProducer<RouteBuildItem> routeProducer, BuildProducer<FilterBuildItem> filterProducer, List<RequireBodyHandlerBuildItem> bodyHandlerRequired, BeanArchiveIndexBuildItem beanArchive, TransformedAnnotationsBuildItem transformedAnnotations, ShutdownContextBuildItem shutdown, LaunchModeBuildItem launchMode, BuildProducer<RouteDescriptionBuildItem> descriptions, Capabilities capabilities, Optional<BeanValidationAnnotationsBuildItem> beanValidationAnnotations, final List<ApplicationClassPredicateBuildItem> predicates) {
        Predicate<String> appClassPredicate = new Predicate<String>(){

            @Override
            public boolean test(String name) {
                int idx = name.lastIndexOf(ReactiveRoutesProcessor.HANDLER_SUFFIX);
                String className = idx != -1 ? name.substring(0, idx) : name;
                for (ApplicationClassPredicateBuildItem i : predicates) {
                    if (!i.test(className)) continue;
                    return true;
                }
                return GeneratedClassGizmoAdaptor.isApplicationClass((String)className);
            }
        };
        Gizmo gizmo = Gizmo.create((ClassOutput)new GeneratedClassGizmo2Adaptor(generatedClass, generatedResource, (Predicate)appClassPredicate)).withDebugInfo(false).withParameters(false);
        IndexView index = beanArchive.getIndex();
        HashMap<RouteMatcher, MethodInfo> matchers = new HashMap<RouteMatcher, MethodInfo>();
        boolean validatorAvailable = capabilities.isPresent("io.quarkus.hibernate.validator");
        for (AnnotatedRouteHandlerBuildItem businessMethod : routeHandlerBusinessMethods) {
            AnnotationInstance routeBaseAnnotation = businessMethod.getRouteBase();
            String pathPrefix = null;
            String[] baseProduces = null;
            String[] baseConsumes = null;
            if (routeBaseAnnotation != null) {
                AnnotationValue consumesValue;
                AnnotationValue producesValue;
                AnnotationValue pathPrefixValue = routeBaseAnnotation.value(VALUE_PATH);
                if (pathPrefixValue != null) {
                    pathPrefix = pathPrefixValue.asString();
                }
                if ((producesValue = routeBaseAnnotation.value(VALUE_PRODUCES)) != null) {
                    baseProduces = producesValue.asStringArray();
                }
                if ((consumesValue = routeBaseAnnotation.value(VALUE_CONSUMES)) != null) {
                    baseConsumes = consumesValue.asStringArray();
                }
            }
            HashMap<String, Handler> routeHandlers = new HashMap<String, Handler>();
            for (AnnotationInstance route : businessMethod.getRoutes()) {
                String routeString = route.toString(true);
                Handler routeHandler = (Handler)routeHandlers.get(routeString);
                AnnotationValue regexValue = route.value(VALUE_REGEX);
                AnnotationValue pathValue = route.value(VALUE_PATH);
                AnnotationValue orderValue = route.valueWithDefault(index, VALUE_ORDER);
                AnnotationValue producesValue = route.valueWithDefault(index, VALUE_PRODUCES);
                AnnotationValue consumesValue = route.valueWithDefault(index, VALUE_CONSUMES);
                AnnotationValue methodsValue = route.valueWithDefault(index, VALUE_METHODS);
                Object path = null;
                String regex = null;
                String[] produces = producesValue.asStringArray();
                String[] consumes = consumesValue.asStringArray();
                AnnotationValue typeValue = route.value(VALUE_TYPE);
                Route.HandlerType routeHandlerType = typeValue == null ? Route.HandlerType.NORMAL : Route.HandlerType.from((String)typeValue.asEnum());
                CharSequence[] methods = (String[])Arrays.stream(methodsValue.asStringArray()).map(String::toUpperCase).toArray(String[]::new);
                int order = orderValue.asInt();
                if (regexValue == null) {
                    if (pathPrefix != null) {
                        StringBuilder prefixed = new StringBuilder();
                        prefixed.append(pathPrefix);
                        if (pathValue == null) {
                            if (routeHandlerType != Route.HandlerType.FAILURE) {
                                prefixed.append(SLASH);
                                prefixed.append(ReactiveRoutesProcessor.dashify(businessMethod.getMethod().name()));
                            }
                        } else {
                            String pathValueStr = pathValue.asString();
                            if (!pathValueStr.isEmpty() && !pathValueStr.startsWith(SLASH)) {
                                prefixed.append(SLASH);
                            }
                            prefixed.append(pathValueStr);
                        }
                        path = prefixed.toString();
                    } else if (pathValue == null) {
                        if (routeHandlerType != Route.HandlerType.FAILURE) {
                            path = ReactiveRoutesProcessor.dashify(businessMethod.getMethod().name());
                        }
                    } else {
                        path = pathValue.asString();
                    }
                    if (path != null && !((String)path).startsWith(SLASH)) {
                        path = SLASH + (String)path;
                    }
                } else {
                    regex = regexValue.asString();
                }
                if (route.value(VALUE_PRODUCES) == null && baseProduces != null) {
                    produces = baseProduces;
                }
                if (route.value(VALUE_CONSUMES) == null && baseConsumes != null) {
                    consumes = baseConsumes;
                }
                HandlerType handlerType = HandlerType.NORMAL;
                if (routeHandlerType != null) {
                    handlerType = switch (routeHandlerType) {
                        case Route.HandlerType.NORMAL -> HandlerType.NORMAL;
                        case Route.HandlerType.BLOCKING -> HandlerType.BLOCKING;
                        case Route.HandlerType.FAILURE -> HandlerType.FAILURE;
                        default -> throw new IllegalStateException("Unknown type " + String.valueOf(routeHandlerType));
                    };
                }
                if (businessMethod.isBlocking()) {
                    if (handlerType == HandlerType.NORMAL) {
                        handlerType = HandlerType.BLOCKING;
                    } else if (handlerType == HandlerType.FAILURE) {
                        throw new IllegalStateException("Invalid combination - a reactive route cannot use @Blocking and use the type `failure` at the same time: " + businessMethod.getMethod().toString());
                    }
                }
                if (routeHandler == null) {
                    String handlerClass = this.generateHandler(new HandlerDescriptor(businessMethod.getMethod(), beanValidationAnnotations.orElse(null), handlerType == HandlerType.FAILURE, produces), businessMethod.getBean(), businessMethod.getMethod(), gizmo, transformedAnnotations, route, reflectiveHierarchy, produces.length > 0 ? produces[0] : null, validatorAvailable, index);
                    reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{handlerClass}).build());
                    routeHandler = recorder.createHandler(handlerClass);
                    routeHandlers.put(routeString, routeHandler);
                }
                routeHandler = recorder.compressRouteHandler(routeHandler, businessMethod.getCompression());
                if (businessMethod.getMethod().hasDeclaredAnnotation(DotNames.RUN_ON_VIRTUAL_THREAD)) {
                    LOGGER.debugf("Route %s#%s() will be executed on a virtual thread", (Object)businessMethod.getMethod().declaringClass().name(), (Object)businessMethod.getMethod().name());
                    routeHandler = recorder.runOnVirtualThread(routeHandler);
                    handlerType = HandlerType.NORMAL;
                }
                RouteMatcher matcher = new RouteMatcher((String)path, regex, produces, consumes, (String[])methods, order);
                matchers.put(matcher, businessMethod.getMethod());
                Function routeFunction = recorder.createRouteFunction(matcher, bodyHandler.getHandler(), businessMethod.shouldAlwaysAuthenticateRoute());
                RouteBuildItem.Builder builder = RouteBuildItem.builder().routeFunction(routeFunction).handlerType(handlerType).handler(routeHandler);
                routeProducer.produce((BuildItem)builder.build());
                if (!launchMode.getLaunchMode().equals((Object)LaunchMode.DEVELOPMENT)) continue;
                if (methods.length == 0) {
                    methods = (String[])Arrays.stream(Route.HttpMethod.values()).map(Enum::name).toArray(String[]::new);
                }
                descriptions.produce((BuildItem)new RouteDescriptionBuildItem(businessMethod.getMethod().declaringClass().name().withoutPackagePrefix() + "#" + businessMethod.getMethod().name() + "()", (String)(regex != null ? regex : path), String.join((CharSequence)", ", methods), produces, consumes));
            }
        }
        for (AnnotatedRouteFilterBuildItem filterMethod : routeFilterBusinessMethods) {
            String handlerClass = this.generateHandler(new HandlerDescriptor(filterMethod.getMethod(), beanValidationAnnotations.orElse(null), false, new String[0]), filterMethod.getBean(), filterMethod.getMethod(), gizmo, transformedAnnotations, filterMethod.getRouteFilter(), reflectiveHierarchy, null, validatorAvailable, index);
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{handlerClass}).build());
            Handler routingHandler = recorder.createHandler(handlerClass);
            AnnotationValue priorityValue = filterMethod.getRouteFilter().value();
            filterProducer.produce((BuildItem)new FilterBuildItem(routingHandler, priorityValue != null ? priorityValue.asInt() : 10));
        }
        this.detectConflictingRoutes(matchers);
    }

    @BuildStep
    AutoAddScopeBuildItem autoAddScope() {
        return AutoAddScopeBuildItem.builder().containsAnnotations(new DotName[]{DotNames.ROUTE, DotNames.ROUTES, DotNames.ROUTE_FILTER}).defaultScope(BuiltinScope.SINGLETON).reason("Found route handler business methods").build();
    }

    private void validateRouteFilterMethod(BeanInfo bean, MethodInfo method) {
        if (!method.returnType().kind().equals((Object)Type.Kind.VOID)) {
            throw new IllegalStateException(String.format("Route filter method must return void [method: %s, bean: %s]", method, bean));
        }
        List params = method.parameterTypes();
        if (params.size() != 1 || !((Type)params.get(0)).name().equals((Object)DotNames.ROUTING_CONTEXT)) {
            throw new IllegalStateException(String.format("Route filter method must accept exactly one parameter of type %s: %s [method: %s, bean: %s]", DotNames.ROUTING_CONTEXT, params, method, bean));
        }
    }

    private void validateRouteMethod(BeanInfo bean, MethodInfo method, TransformedAnnotationsBuildItem transformedAnnotations, IndexView index, AnnotationInstance routeAnnotation) {
        List params = method.parameterTypes();
        if (params.isEmpty()) {
            if (method.returnType().kind() == Type.Kind.VOID && params.isEmpty()) {
                throw new IllegalStateException(String.format("Route method that returns void must accept at least one injectable parameter [method: %s, bean: %s]", method, bean));
            }
        } else {
            AnnotationValue typeValue = routeAnnotation.value(VALUE_TYPE);
            Route.HandlerType handlerType = typeValue == null ? Route.HandlerType.NORMAL : Route.HandlerType.from((String)typeValue.asEnum());
            DotName returnTypeName = method.returnType().name();
            if ((returnTypeName.equals((Object)DotNames.UNI) || returnTypeName.equals((Object)DotNames.MULTI) || returnTypeName.equals((Object)DotNames.COMPLETION_STAGE)) && method.returnType().kind() == Type.Kind.CLASS) {
                throw new IllegalStateException(String.format("Route business method returning a Uni/Multi/CompletionStage must declare a type argument on the return type [method: %s, bean: %s]", method, bean));
            }
            boolean canEndResponse = false;
            int idx = 0;
            int failureParams = 0;
            for (Type paramType : params) {
                Set paramAnnotations;
                List<ParameterInjector> injectors = this.getMatchingInjectors(paramType, paramAnnotations = Annotations.getParameterAnnotations((Function)transformedAnnotations, (MethodInfo)method, (int)idx), index);
                if (injectors.isEmpty()) {
                    throw new IllegalStateException(String.format("No parameter injector found for parameter %s of route method %s declared on %s", idx, method, bean));
                }
                if (injectors.size() > 1) {
                    throw new IllegalStateException(String.format("Multiple parameter injectors found for parameter %s of route method %s declared on %s", idx, method, bean));
                }
                ParameterInjector injector = injectors.get(0);
                if (injector.getTargetHandlerType() != null && !injector.getTargetHandlerType().equals((Object)handlerType)) {
                    throw new IllegalStateException(String.format("HandlerType.%s is not legal for parameter %s of route method %s declared on %s", injector.getTargetHandlerType(), idx, method, bean));
                }
                injector.validate(bean, method, routeAnnotation, paramType, paramAnnotations);
                if (injector.canEndResponse) {
                    canEndResponse = true;
                }
                if (Route.HandlerType.FAILURE == handlerType && ReactiveRoutesProcessor.isThrowable(paramType, index)) {
                    ++failureParams;
                }
                ++idx;
            }
            if (method.returnType().kind() == Type.Kind.VOID && !canEndResponse) {
                throw new IllegalStateException(String.format("Route method that returns void must accept at least one parameter that can end the response [method: %s, bean: %s]", method, bean));
            }
            if (failureParams > 1) {
                throw new IllegalStateException(String.format("A failure handler may only define one failure parameter - route method %s declared on %s", method, bean));
            }
        }
    }

    private String generateHandler(HandlerDescriptor desc, BeanInfo bean, MethodInfo method, Gizmo gizmo, TransformedAnnotationsBuildItem transformedAnnotations, AnnotationInstance routeAnnotation, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, String defaultProduces, boolean validatorAvailable, IndexView index) {
        if (desc.requireValidation() && !validatorAvailable) {
            throw new IllegalStateException("A route requires validation, but the Hibernate Validator extension is not present");
        }
        StringBuilder signature = new StringBuilder();
        signature.append(method.name()).append("_").append(method.returnType().name());
        for (Type parameterType : method.parameterTypes()) {
            signature.append(parameterType.name());
        }
        signature.append(routeAnnotation.toString(true));
        String generatedName = bean.getImplClazz().name().toString() + "_RouteHandler_" + method.name() + "_" + HashUtil.sha1((String)signature.toString());
        gizmo.class_(generatedName, cc -> {
            FieldDesc containerField;
            FieldDesc contextField;
            cc.extends_(RouteHandler.class);
            FieldDesc beanField = cc.field("bean", fc -> {
                fc.private_();
                fc.final_();
                fc.setType(InjectableBean.class);
            });
            if (BuiltinScope.APPLICATION.is(bean.getScope()) || BuiltinScope.SINGLETON.is(bean.getScope())) {
                contextField = cc.field("context", fc -> {
                    fc.private_();
                    fc.final_();
                    fc.setType(InjectableContext.class);
                });
                containerField = null;
            } else {
                contextField = null;
                containerField = cc.field("container", fc -> {
                    fc.private_();
                    fc.final_();
                    fc.setType(ArcContainer.class);
                });
            }
            FieldDesc validatorField = desc.isProducedResponseValidated() ? cc.field("validator", fc -> {
                fc.public_();
                fc.final_();
                fc.setType(Methods.VALIDATION_VALIDATOR);
            }) : null;
            this.generateConstructor((ClassCreator)cc, bean, beanField, contextField, containerField, validatorField);
            this.generateInvoke((ClassCreator)cc, desc, bean, method, beanField, contextField, containerField, validatorField, transformedAnnotations, reflectiveHierarchy, defaultProduces, index);
        });
        return generatedName;
    }

    void generateConstructor(ClassCreator cc, BeanInfo btBean, FieldDesc beanField, FieldDesc contextField, FieldDesc containerField, FieldDesc validatorField) {
        cc.constructor(mc -> mc.body(bc -> {
            bc.invokeSpecial(Methods.ROUTE_HANDLER_CTOR, (Expr)cc.this_());
            LocalVar arc = bc.localVar("arc", bc.invokeStatic(Methods.ARC_CONTAINER));
            LocalVar rtBean = bc.localVar("bean", bc.invokeInterface(Methods.ARC_CONTAINER_BEAN, (Expr)arc, (Expr)Const.of((String)btBean.getIdentifier())));
            bc.set((Assignable)cc.this_().field(beanField), (Expr)rtBean);
            if (contextField != null) {
                Expr scope = bc.invokeInterface(Methods.BEAN_GET_SCOPE, (Expr)rtBean);
                Expr context = bc.invokeInterface(Methods.ARC_CONTAINER_GET_ACTIVE_CONTEXT, (Expr)arc, scope);
                bc.set((Assignable)cc.this_().field(contextField), context);
            }
            if (containerField != null) {
                bc.set((Assignable)cc.this_().field(containerField), (Expr)arc);
            }
            if (validatorField != null) {
                bc.set((Assignable)cc.this_().field(validatorField), bc.invokeStatic(Methods.VALIDATION_GET_VALIDATOR, (Expr)arc));
            }
            bc.return_();
        }));
    }

    void generateInvoke(ClassCreator cc, HandlerDescriptor descriptor, BeanInfo btBean, MethodInfo method, FieldDesc beanField, FieldDesc contextField, FieldDesc containerField, FieldDesc validatorField, TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, String defaultProduces, IndexView index) {
        cc.method("invoke", mc -> {
            mc.returning(Void.TYPE);
            ParamVar routingContext = mc.parameter("routingContext", RoutingContext.class);
            mc.body(b0 -> {
                Type failureType;
                if (descriptor.isFailureHandler() && (failureType = this.getFailureType(method.parameterTypes(), index)) != null) {
                    LocalVar failure = b0.localVar("failure", b0.invokeInterface(Methods.FAILURE, (Expr)routingContext));
                    b0.ifNull((Expr)failure, b1 -> {
                        b1.invokeInterface(Methods.NEXT, (Expr)routingContext);
                        b1.return_();
                    });
                    Expr isAssignable = b0.invokeVirtual(Methods.IS_ASSIGNABLE_FROM, (Expr)Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)failureType)), b0.withObject((Expr)failure).getClass_());
                    b0.ifNot(isAssignable, b1 -> {
                        b1.invokeInterface(Methods.NEXT, (Expr)routingContext);
                        b1.return_();
                    });
                }
                InstanceFieldVar rtBean = cc.this_().field(beanField);
                LocalVar creationalContext = BuiltinScope.DEPENDENT.is(btBean.getScope()) ? b0.localVar("cc", b0.new_(Methods.CREATIONAL_CONTEXT_IMPL_CTOR, (Expr)rtBean)) : null;
                LocalVar beanInstance = b0.localVar("beanInstance", b0.blockExpr(ConstantDescs.CD_Object, arg_0 -> ReactiveRoutesProcessor.lambda$generateInvoke$13(btBean, (FieldVar)rtBean, creationalContext, contextField, cc, containerField, arg_0)));
                ClassDesc[] params = new ClassDesc[method.parametersCount()];
                LocalVar[] args = new LocalVar[method.parametersCount()];
                int idx = 0;
                for (MethodParameterInfo methodParam : method.parameters()) {
                    Set paramAnnotations = Annotations.getParameterAnnotations((Function)transformedAnnotations, (MethodInfo)method, (int)idx);
                    args[idx] = this.getMatchingInjectors(methodParam.type(), paramAnnotations, index).get(0).getValue(methodParam, paramAnnotations, (Var)routingContext, (BlockCreator)b0, reflectiveHierarchy);
                    params[idx] = Jandex2Gizmo.classDescOf((Type)methodParam.type());
                    ++idx;
                }
                ClassMethodDesc desc = ClassMethodDesc.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)btBean.getImplClazz()), (String)method.name(), (MethodTypeDesc)MethodTypeDesc.of(Jandex2Gizmo.classDescOf((Type)descriptor.getReturnType()), params));
                b0.invokeStatic(Methods.ROUTE_HANDLERS_SET_CONTENT_TYPE, (Expr)routingContext, (Expr)(defaultProduces == null ? Const.ofNull(String.class) : Const.of((String)defaultProduces)));
                LocalVar result = descriptor.isReturningUni() ? b0.localVar("result", (Expr)Const.ofDefault(Uni.class)) : (descriptor.isReturningMulti() ? b0.localVar("result", (Expr)Const.ofDefault(Multi.class)) : (descriptor.isReturningCompletionStage() ? b0.localVar("result", (Expr)Const.ofDefault(CompletionStage.class)) : b0.localVar("result", (Expr)Const.ofDefault(Object.class))));
                if (!descriptor.requireValidation()) {
                    Expr value = b0.invokeVirtual((MethodDesc)desc, (Expr)beanInstance, (Expr[])args);
                    if (!value.isVoid()) {
                        b0.set((Assignable)result, value);
                    }
                } else {
                    b0.try_(arg_0 -> ReactiveRoutesProcessor.lambda$generateInvoke$16((MethodDesc)desc, beanInstance, args, result, descriptor, routingContext, arg_0));
                }
                MethodDesc end = Methods.getEndMethodForContentType(descriptor);
                if (descriptor.isReturningUni()) {
                    b0.invokeVirtual(Methods.UNI_SUBSCRIBE_WITH, b0.invokeInterface(Methods.UNI_SUBSCRIBE, (Expr)result), this.getUniOnItemCallback(descriptor, (BlockCreator)b0, (Var)routingContext, end, cc.this_(), validatorField), this.getUniOnFailureCallback((BlockCreator)b0, (Var)routingContext));
                    ReactiveRoutesProcessor.registerForReflection(descriptor.getPayloadType(), reflectiveHierarchy);
                } else if (descriptor.isReturningMulti()) {
                    String contentType = descriptor.getFirstContentType();
                    if (contentType != null) {
                        if (contentType.toLowerCase().startsWith("text/event-stream")) {
                            this.handleSSEMulti(descriptor, (BlockCreator)b0, (Var)routingContext, (Expr)result);
                        } else if (contentType.toLowerCase().startsWith("application/json")) {
                            this.handleJsonArrayMulti(descriptor, (BlockCreator)b0, (Var)routingContext, (Expr)result);
                        } else if (contentType.toLowerCase().startsWith("application/x-ndjson") || contentType.toLowerCase().startsWith("application/stream+json")) {
                            this.handleNdjsonMulti(descriptor, (BlockCreator)b0, (Var)routingContext, (Expr)result);
                        } else {
                            this.handleRegularMulti(descriptor, (BlockCreator)b0, (Var)routingContext, (Expr)result);
                        }
                    } else {
                        b0.ifElse(b0.invokeStatic(Methods.IS_SSE, (Expr)result), b1 -> this.handleSSEMulti(descriptor, (BlockCreator)b1, (Var)routingContext, (Expr)result), b1 -> b1.ifElse(b1.invokeStatic(Methods.IS_NDJSON, (Expr)result), b2 -> this.handleNdjsonMulti(descriptor, (BlockCreator)b2, (Var)routingContext, (Expr)result), b2 -> b2.ifElse(b2.invokeStatic(Methods.IS_JSON_ARRAY, (Expr)result), b3 -> this.handleJsonArrayMulti(descriptor, (BlockCreator)b3, (Var)routingContext, (Expr)result), b3 -> this.handleRegularMulti(descriptor, (BlockCreator)b3, (Var)routingContext, (Expr)result))));
                    }
                    ReactiveRoutesProcessor.registerForReflection(descriptor.getPayloadType(), reflectiveHierarchy);
                } else if (descriptor.isReturningCompletionStage()) {
                    Expr consumer = this.getWhenCompleteCallback(descriptor, (BlockCreator)b0, (Var)routingContext, end, cc.this_(), validatorField);
                    b0.invokeInterface(Methods.CS_WHEN_COMPLETE, (Expr)result, consumer);
                    ReactiveRoutesProcessor.registerForReflection(descriptor.getPayloadType(), reflectiveHierarchy);
                } else if (descriptor.getPayloadType() != null) {
                    LocalVar response = b0.localVar("response", b0.invokeInterface(Methods.RESPONSE, (Expr)routingContext));
                    Expr content = this.getContentToWrite(descriptor, (Var)response, (Var)result, (BlockCreator)b0, (Expr)cc.this_(), validatorField);
                    b0.invokeInterface(end, (Expr)response, content);
                    ReactiveRoutesProcessor.registerForReflection(descriptor.getPayloadType(), reflectiveHierarchy);
                }
                if (BuiltinScope.DEPENDENT.is(btBean.getScope())) {
                    b0.invokeInterface(Methods.INJECTABLE_BEAN_DESTROY, (Expr)rtBean, (Expr)beanInstance, (Expr)creationalContext);
                }
                b0.return_();
            });
        });
    }

    private Type getFailureType(List<Type> parameters, IndexView index) {
        for (Type paramType : parameters) {
            if (!ReactiveRoutesProcessor.isThrowable(paramType, index)) continue;
            return paramType;
        }
        return null;
    }

    private static boolean isThrowable(Type paramType, IndexView index) {
        ClassInfo clazz = index.getClassByName(paramType.name());
        while (clazz != null && clazz.superName() != null) {
            if (DotNames.EXCEPTION.equals((Object)clazz.superName()) || DotNames.THROWABLE.equals((Object)clazz.superName())) {
                return true;
            }
            clazz = index.getClassByName(clazz.superName());
        }
        return false;
    }

    private static void registerForReflection(Type contentType, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
        if (TYPES_IGNORED_FOR_REFLECTION.contains(contentType.name())) {
            return;
        }
        reflectiveHierarchy.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((Type)contentType).ignoreTypePredicate(ReflectiveHierarchyBuildItem.DefaultIgnoreTypePredicate.INSTANCE.or(TYPES_IGNORED_FOR_REFLECTION::contains)).source(ReactiveRoutesProcessor.class.getSimpleName() + " > " + String.valueOf(contentType)).build());
    }

    private void handleRegularMulti(HandlerDescriptor descriptor, BlockCreator bc, Var routingContext, Expr res) {
        if (Methods.isNoContent(descriptor)) {
            bc.invokeStatic(Methods.MULTI_SUBSCRIBE_VOID, res, (Expr)routingContext);
        } else if (descriptor.isPayloadBuffer()) {
            bc.invokeStatic(Methods.MULTI_SUBSCRIBE_BUFFER, res, (Expr)routingContext);
        } else if (descriptor.isPayloadMutinyBuffer()) {
            bc.invokeStatic(Methods.MULTI_SUBSCRIBE_MUTINY_BUFFER, res, (Expr)routingContext);
        } else if (descriptor.isPayloadString()) {
            bc.invokeStatic(Methods.MULTI_SUBSCRIBE_STRING, res, (Expr)routingContext);
        } else {
            bc.invokeStatic(Methods.MULTI_SUBSCRIBE_OBJECT, res, (Expr)routingContext);
        }
    }

    private void handleSSEMulti(HandlerDescriptor descriptor, BlockCreator bc, Var routingContext, Expr res) {
        if (Methods.isNoContent(descriptor)) {
            bc.invokeStatic(Methods.MULTI_SUBSCRIBE_VOID, res, (Expr)routingContext);
        } else if (descriptor.isPayloadBuffer()) {
            bc.invokeStatic(Methods.MULTI_SSE_SUBSCRIBE_BUFFER, res, (Expr)routingContext);
        } else if (descriptor.isPayloadMutinyBuffer()) {
            bc.invokeStatic(Methods.MULTI_SSE_SUBSCRIBE_MUTINY_BUFFER, res, (Expr)routingContext);
        } else if (descriptor.isPayloadString()) {
            bc.invokeStatic(Methods.MULTI_SSE_SUBSCRIBE_STRING, res, (Expr)routingContext);
        } else {
            bc.invokeStatic(Methods.MULTI_SSE_SUBSCRIBE_OBJECT, res, (Expr)routingContext);
        }
    }

    private void handleNdjsonMulti(HandlerDescriptor descriptor, BlockCreator bc, Var routingContext, Expr res) {
        if (Methods.isNoContent(descriptor)) {
            bc.invokeStatic(Methods.MULTI_SUBSCRIBE_VOID, res, (Expr)routingContext);
        } else if (descriptor.isPayloadString()) {
            bc.invokeStatic(Methods.MULTI_NDJSON_SUBSCRIBE_STRING, res, (Expr)routingContext);
        } else if (descriptor.isPayloadBuffer() || descriptor.isPayloadMutinyBuffer()) {
            bc.invokeStatic(Methods.MULTI_JSON_FAIL, (Expr)routingContext);
        } else {
            bc.invokeStatic(Methods.MULTI_NDJSON_SUBSCRIBE_OBJECT, res, (Expr)routingContext);
        }
    }

    private void handleJsonArrayMulti(HandlerDescriptor descriptor, BlockCreator bc, Var routingContext, Expr res) {
        if (Methods.isNoContent(descriptor)) {
            bc.invokeStatic(Methods.MULTI_JSON_SUBSCRIBE_VOID, res, (Expr)routingContext);
        } else if (descriptor.isPayloadString()) {
            bc.invokeStatic(Methods.MULTI_JSON_SUBSCRIBE_STRING, res, (Expr)routingContext);
        } else if (descriptor.isPayloadBuffer() || descriptor.isPayloadMutinyBuffer()) {
            bc.invokeStatic(Methods.MULTI_JSON_FAIL, (Expr)routingContext);
        } else {
            bc.invokeStatic(Methods.MULTI_JSON_SUBSCRIBE_OBJECT, res, (Expr)routingContext);
        }
    }

    private Expr getUniOnItemCallback(HandlerDescriptor descriptor, BlockCreator bc, Var routingContext, MethodDesc end, This this_, FieldDesc validatorField) {
        return bc.lambda(Consumer.class, lc -> {
            Var capturedRoutingContext = lc.capture("routingContext", (Expr)routingContext);
            Var capturedThis = lc.capture("this_", (Expr)this_);
            ParamVar item = lc.parameter("item", 0);
            lc.body(lb0 -> {
                LocalVar response = lb0.localVar("response", lb0.invokeInterface(Methods.RESPONSE, (Expr)capturedRoutingContext));
                if (Methods.isNoContent(descriptor)) {
                    lb0.invokeInterface(Methods.SET_STATUS, (Expr)response, (Expr)Const.of((int)204));
                    lb0.invokeInterface(Methods.END, (Expr)response);
                } else {
                    lb0.ifElse(lb0.isNotNull((Expr)item), lb1 -> {
                        Expr content = this.getContentToWrite(descriptor, (Var)response, (Var)item, (BlockCreator)lb1, (Expr)capturedThis, validatorField);
                        lb1.invokeInterface(end, (Expr)response, content);
                    }, lb1 -> lb1.invokeInterface(Methods.FAIL, (Expr)capturedRoutingContext, Methods.createNpeItemIsNull(lb1)));
                }
                lb0.return_();
            });
        });
    }

    private Expr getUniOnFailureCallback(BlockCreator bc, Var routingContext) {
        return bc.new_(ConstructorDesc.of(UniFailureCallback.class, (Class[])new Class[]{RoutingContext.class}), (Expr)routingContext);
    }

    private Expr getWhenCompleteCallback(HandlerDescriptor descriptor, BlockCreator bc, Var routingContext, MethodDesc end, This this_, FieldDesc validatorField) {
        return bc.lambda(BiConsumer.class, lc -> {
            Var capturedThis = lc.capture("this_", (Expr)this_);
            Var capturedRoutingContext = lc.capture("routingContext", (Expr)routingContext);
            ParamVar value = lc.parameter("value", 0);
            ParamVar error = lc.parameter("error", 1);
            lc.body(lb0 -> {
                LocalVar response = lb0.localVar("response", lb0.invokeInterface(Methods.RESPONSE, (Expr)capturedRoutingContext));
                lb0.ifElse(lb0.isNull((Expr)error), lb1 -> {
                    if (Methods.isNoContent(descriptor)) {
                        lb1.invokeInterface(Methods.SET_STATUS, (Expr)response, (Expr)Const.of((int)204));
                        lb1.invokeInterface(Methods.END, (Expr)response);
                    } else {
                        lb1.ifElse(lb1.isNotNull((Expr)value), lb2 -> {
                            Expr content = this.getContentToWrite(descriptor, (Var)response, (Var)value, (BlockCreator)lb2, (Expr)capturedThis, validatorField);
                            lb2.invokeInterface(end, (Expr)response, content);
                        }, lb2 -> {
                            Expr npe = lb2.new_(ConstructorDesc.of(NullPointerException.class, (Class[])new Class[]{String.class}), (Expr)Const.of((String)("Null is not a valid return value for @Route method with return type: " + String.valueOf(descriptor.getReturnType()))));
                            lb2.invokeInterface(Methods.FAIL, (Expr)capturedRoutingContext, npe);
                        });
                    }
                }, lb1 -> lb1.invokeInterface(Methods.FAIL, (Expr)capturedRoutingContext, (Expr)error));
                lb0.return_();
            });
        });
    }

    private Expr getContentToWrite(HandlerDescriptor descriptor, Var response, Var result, BlockCreator bc, Expr this_, FieldDesc validatorField) {
        if (descriptor.isPayloadString() || descriptor.isPayloadBuffer()) {
            return result;
        }
        if (descriptor.isPayloadMutinyBuffer()) {
            return bc.invokeVirtual(Methods.MUTINY_GET_DELEGATE, (Expr)result);
        }
        Methods.setContentTypeToJson(response, bc);
        if (descriptor.isProducedResponseValidated() && (descriptor.isReturningUni() || descriptor.isReturningMulti() || descriptor.isReturningCompletionStage())) {
            return Methods.validateProducedItem(response, bc, result, this_, validatorField);
        }
        return bc.invokeStatic(Methods.JSON_ENCODE, (Expr)result);
    }

    private static String dashify(String value) {
        StringBuilder ret = new StringBuilder();
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (i != 0 && i != chars.length - 1 && Character.isUpperCase(c)) {
                ret.append('-');
            }
            ret.append(Character.toLowerCase(c));
        }
        return ret.toString();
    }

    private void detectConflictingRoutes(Map<RouteMatcher, MethodInfo> matchers) {
        if (matchers.isEmpty()) {
            return;
        }
        HashSet groups = new HashSet();
        for (Map.Entry<RouteMatcher, MethodInfo> entry : matchers.entrySet()) {
            Set group = new LinkedHashSet<RouteMatcher>();
            ((HashSet)group).add(entry.getKey());
            matchers.entrySet().stream().filter(e -> {
                if (((RouteMatcher)e.getKey()).equals(entry.getKey())) {
                    return false;
                }
                if (((MethodInfo)e.getValue()).equals(entry.getValue())) {
                    return false;
                }
                if (((RouteMatcher)e.getKey()).getOrder() != ((RouteMatcher)entry.getKey()).getOrder()) {
                    return false;
                }
                return ReactiveRoutesProcessor.canMatchSameRequest((RouteMatcher)entry.getKey(), (RouteMatcher)e.getKey());
            }).map(Map.Entry::getKey).forEach(arg_0 -> group.add(arg_0));
            groups.add(group);
        }
        boolean conflictExists = false;
        for (Set group : groups) {
            if (group.size() <= 1) continue;
            Iterator it = group.iterator();
            RouteMatcher firstMatcher = (RouteMatcher)it.next();
            MethodInfo firstMethod = matchers.get(firstMatcher);
            conflictExists = true;
            StringBuilder conflictingRoutes = new StringBuilder();
            while (it.hasNext()) {
                RouteMatcher rm = (RouteMatcher)it.next();
                MethodInfo method = matchers.get(rm);
                conflictingRoutes.append("\n\t- ").append(method.declaringClass().name().toString()).append("#").append(method.name()).append("()");
            }
            LOGGER.warnf("Route %s#%s() can match the same request and has the same order [%s] as:%s", new Object[]{firstMethod.declaringClass().name(), firstMethod.name(), firstMatcher.getOrder(), conflictingRoutes});
        }
        if (conflictExists) {
            LOGGER.warn((Object)"You can use @Route#order() to ensure the routes are not executed in random order");
        }
    }

    static boolean canMatchSameRequest(RouteMatcher m1, RouteMatcher m2) {
        if (m1.getRegex() != null ? !Objects.equals(m1.getRegex(), m2.getRegex()) : m1.getPath() != null && !Objects.equals(m1.getPath(), m2.getPath())) {
            return false;
        }
        if (m1.getMethods().length > 0 && m2.getMethods().length > 0 && !Arrays.equals(m1.getMethods(), m2.getMethods())) {
            return false;
        }
        if (m1.getProduces().length > 0 && m2.getProduces().length > 0 && !Arrays.equals(m1.getProduces(), m2.getProduces())) {
            return false;
        }
        return m1.getConsumes().length <= 0 || m2.getConsumes().length <= 0 || Arrays.equals(m1.getConsumes(), m2.getConsumes());
    }

    private List<ParameterInjector> getMatchingInjectors(Type paramType, Set<AnnotationInstance> paramAnnotations, IndexView index) {
        ArrayList<ParameterInjector> injectors = new ArrayList<ParameterInjector>();
        for (ParameterInjector injector : PARAM_INJECTORS) {
            if (!injector.matches(paramType, paramAnnotations, index)) continue;
            injectors.add(injector);
        }
        return injectors;
    }

    static List<ParameterInjector> initParamInjectors() {
        ArrayList<ParameterInjector> injectors = new ArrayList<ParameterInjector>();
        injectors.add(ParameterInjector.builder().canEndResponse().matchType(DotNames.ROUTING_CONTEXT).valueProvider(new ValueProvider(){

            @Override
            public Expr get(MethodParameterInfo methodParam, Set<AnnotationInstance> annotations, Var routingContext, BlockCreator bc, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                return routingContext;
            }
        }).build());
        injectors.add(ParameterInjector.builder().canEndResponse().matchType(DotNames.ROUTING_EXCHANGE).valueProvider(new ValueProvider(){

            @Override
            public Expr get(MethodParameterInfo methodParam, Set<AnnotationInstance> annotations, Var routingContext, BlockCreator bc, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                return bc.new_(ConstructorDesc.of(RoutingExchangeImpl.class, (Class[])new Class[]{RoutingContext.class}), (Expr)routingContext);
            }
        }).build());
        injectors.add(ParameterInjector.builder().canEndResponse().matchType(DotNames.HTTP_SERVER_REQUEST).valueProvider(new ValueProvider(){

            @Override
            public Expr get(MethodParameterInfo methodParam, Set<AnnotationInstance> annotations, Var routingContext, BlockCreator bc, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                return bc.invokeInterface(Methods.REQUEST, (Expr)routingContext);
            }
        }).build());
        injectors.add(ParameterInjector.builder().canEndResponse().matchType(DotNames.HTTP_SERVER_RESPONSE).valueProvider(new ValueProvider(){

            @Override
            public Expr get(MethodParameterInfo methodParam, Set<AnnotationInstance> annotations, Var routingContext, BlockCreator bc, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                return bc.invokeInterface(Methods.RESPONSE, (Expr)routingContext);
            }
        }).build());
        injectors.add(ParameterInjector.builder().canEndResponse().matchType(DotNames.MUTINY_HTTP_SERVER_REQUEST).valueProvider(new ValueProvider(){

            @Override
            public Expr get(MethodParameterInfo methodParam, Set<AnnotationInstance> annotations, Var routingContext, BlockCreator bc, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                return bc.new_(ConstructorDesc.of(HttpServerRequest.class, (Class[])new Class[]{io.vertx.core.http.HttpServerRequest.class}), bc.invokeInterface(Methods.REQUEST, (Expr)routingContext));
            }
        }).build());
        injectors.add(ParameterInjector.builder().canEndResponse().matchType(DotNames.MUTINY_HTTP_SERVER_RESPONSE).valueProvider(new ValueProvider(){

            @Override
            public Expr get(MethodParameterInfo methodParam, Set<AnnotationInstance> annotations, Var routingContext, BlockCreator bc, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                return bc.new_(ConstructorDesc.of(HttpServerResponse.class, (Class[])new Class[]{io.vertx.core.http.HttpServerResponse.class}), bc.invokeInterface(Methods.RESPONSE, (Expr)routingContext));
            }
        }).build());
        injectors.add(ParameterInjector.builder().matchPrimitiveWrappers().matchType(DotName.STRING_NAME).matchOptionalOf(DotName.STRING_NAME).matchListOf(DotName.STRING_NAME).requireAnnotations(DotNames.PARAM).valueProvider(new ParamAndHeaderProvider(DotNames.PARAM, Methods.REQUEST_PARAMS, Methods.REQUEST_GET_PARAM)).validate(new ParamValidator(){

            @Override
            public void validate(BeanInfo bean, MethodInfo method, AnnotationInstance routeAnnotation, Type paramType, Set<AnnotationInstance> paramAnnotations) {
                AnnotationInstance paramAnnotation = Annotations.find(paramAnnotations, (DotName)DotNames.PARAM);
                AnnotationValue paramNameValue = paramAnnotation.value();
                if (paramNameValue != null && !paramNameValue.asString().equals("<<element name>>")) {
                    String path;
                    String paramName = paramNameValue.asString();
                    AnnotationValue regexValue = routeAnnotation.value(ReactiveRoutesProcessor.VALUE_REGEX);
                    AnnotationValue pathValue = routeAnnotation.value(ReactiveRoutesProcessor.VALUE_PATH);
                    if (regexValue == null && pathValue != null && (path = pathValue.asString()).contains(":" + paramName) && !PATH_PARAM_PATTERN.matcher(paramName).matches()) {
                        throw new IllegalStateException(String.format("A path param name must only contain word characters (a-zA-Z_0-9): %s [route method %s declared on %s]", paramName, method, bean.getBeanClass()));
                    }
                }
            }
        }).build());
        injectors.add(ParameterInjector.builder().matchPrimitiveWrappers().matchType(DotName.STRING_NAME).matchOptionalOf(DotName.STRING_NAME).matchListOf(DotName.STRING_NAME).requireAnnotations(DotNames.HEADER).valueProvider(new ParamAndHeaderProvider(DotNames.HEADER, Methods.REQUEST_HEADERS, Methods.REQUEST_GET_HEADER)).build());
        injectors.add(ParameterInjector.builder().matchType(DotName.STRING_NAME).matchType(DotNames.BUFFER).matchType(DotNames.JSON_OBJECT).matchType(DotNames.JSON_ARRAY).requireAnnotations(DotNames.BODY).valueProvider(new ValueProvider(){

            @Override
            public Expr get(MethodParameterInfo methodParam, Set<AnnotationInstance> annotations, Var routingContext, BlockCreator bc, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                Type paramType = methodParam.type();
                if (paramType.name().equals((Object)DotName.STRING_NAME)) {
                    return bc.invokeInterface(Methods.GET_BODY_AS_STRING, (Expr)routingContext);
                }
                if (paramType.name().equals((Object)DotNames.BUFFER)) {
                    return bc.invokeInterface(Methods.GET_BODY, (Expr)routingContext);
                }
                if (paramType.name().equals((Object)DotNames.JSON_OBJECT)) {
                    return bc.invokeInterface(Methods.GET_BODY_AS_JSON, (Expr)routingContext);
                }
                if (paramType.name().equals((Object)DotNames.JSON_ARRAY)) {
                    return bc.invokeInterface(Methods.GET_BODY_AS_JSON_ARRAY, (Expr)routingContext);
                }
                throw new IllegalArgumentException("Unsupported param type: " + String.valueOf(paramType));
            }
        }).build());
        injectors.add(ParameterInjector.builder().skipType(DotName.STRING_NAME).skipType(DotNames.BUFFER).skipType(DotNames.JSON_OBJECT).skipType(DotNames.JSON_ARRAY).requireAnnotations(DotNames.BODY).valueProvider(new ValueProvider(){

            @Override
            public Expr get(MethodParameterInfo methodParam, Set<AnnotationInstance> annotations, Var routingContext, BlockCreator b0, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                Type paramType = methodParam.type();
                ReactiveRoutesProcessor.registerForReflection(paramType, reflectiveHierarchy);
                LocalVar bodyAsJson = b0.localVar("bodyAsJson", b0.invokeInterface(Methods.GET_BODY_AS_JSON, (Expr)routingContext));
                LocalVar result = b0.localVar("result", (Expr)Const.ofDefault(Object.class));
                b0.ifNotNull((Expr)bodyAsJson, b1 -> b1.set((Assignable)result, b1.invokeVirtual(Methods.JSON_OBJECT_MAP_TO, (Expr)bodyAsJson, (Expr)Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)paramType)))));
                return result;
            }
        }).build());
        injectors.add(ParameterInjector.builder().targetHandlerType(Route.HandlerType.FAILURE).match(new TriPredicate<Type, Set<AnnotationInstance>, IndexView>(){

            @Override
            public boolean test(Type paramType, Set<AnnotationInstance> paramAnnotations, IndexView index) {
                return ReactiveRoutesProcessor.isThrowable(paramType, index) && !Annotations.contains(paramAnnotations, (DotName)DotNames.BODY);
            }
        }).valueProvider(new ValueProvider(){

            @Override
            public Expr get(MethodParameterInfo methodParam, Set<AnnotationInstance> annotations, Var routingContext, BlockCreator bc, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                return bc.cast(bc.invokeInterface(Methods.FAILURE, (Expr)routingContext), Jandex2Gizmo.classDescOf((Type)methodParam.type()));
            }
        }).build());
        return injectors;
    }

    static void convertPrimitiveAndSet(LocalVar param, Type paramType, BlockCreator b0, MethodParameterInfo methodParam) {
        b0.ifNotNull((Expr)param, b1 -> b1.try_(tc -> {
            tc.body(b2 -> {
                if (paramType.name().equals((Object)DotName.BOOLEAN_CLASS_NAME)) {
                    b2.set((Assignable)param, b2.invokeStatic(Methods.BOOLEAN_VALUE_OF, (Expr)param));
                } else if (paramType.name().equals((Object)DotName.BYTE_CLASS_NAME)) {
                    b2.set((Assignable)param, b2.invokeStatic(Methods.BYTE_VALUE_OF, (Expr)param));
                } else if (paramType.name().equals((Object)DotName.SHORT_CLASS_NAME)) {
                    b2.set((Assignable)param, b2.invokeStatic(Methods.SHORT_VALUE_OF, (Expr)param));
                } else if (paramType.name().equals((Object)DotName.INTEGER_CLASS_NAME)) {
                    b2.set((Assignable)param, b2.invokeStatic(Methods.INTEGER_VALUE_OF, (Expr)param));
                } else if (paramType.name().equals((Object)DotName.LONG_CLASS_NAME)) {
                    b2.set((Assignable)param, b2.invokeStatic(Methods.LONG_VALUE_OF, (Expr)param));
                } else if (paramType.name().equals((Object)DotName.FLOAT_CLASS_NAME)) {
                    b2.set((Assignable)param, b2.invokeStatic(Methods.FLOAT_VALUE_OF, (Expr)param));
                } else if (paramType.name().equals((Object)DotName.DOUBLE_CLASS_NAME)) {
                    b2.set((Assignable)param, b2.invokeStatic(Methods.DOUBLE_VALUE_OF, (Expr)param));
                } else if (paramType.name().equals((Object)DotName.CHARACTER_CLASS_NAME)) {
                    b2.set((Assignable)param, b2.invokeStatic(Methods.CHARACTER_VALUE_OF, b2.withString((Expr)param).charAt(0)));
                } else {
                    throw new IllegalArgumentException("Unsupported param type: " + String.valueOf(paramType));
                }
            });
            tc.catch_(Throwable.class, "e", (b2, e) -> b2.throw_(b2.new_(ConstructorDesc.of(IllegalArgumentException.class, (Class[])new Class[]{String.class, Throwable.class}), (Expr)Const.of((String)("Error converting parameter #" + methodParam.position() + " of method " + String.valueOf(methodParam.method().declaringClass()) + "." + methodParam.method().name() + "()")), (Expr)e)));
        }));
    }

    private static /* synthetic */ void lambda$generateInvoke$16(MethodDesc desc, LocalVar beanInstance, LocalVar[] args, LocalVar result, HandlerDescriptor descriptor, ParamVar routingContext, TryCreator tc) {
        tc.body(b1 -> {
            Expr value = b1.invokeVirtual(desc, (Expr)beanInstance, (Expr[])args);
            if (!value.isVoid()) {
                b1.set((Assignable)result, value);
            }
        });
        tc.catch_(Methods.VALIDATION_CONSTRAINT_VIOLATION_EXCEPTION, "e", (b1, e) -> {
            boolean forceJsonEncoding = !descriptor.isPayloadString() && !descriptor.isPayloadBuffer() && !descriptor.isPayloadMutinyBuffer();
            b1.invokeStatic(Methods.VALIDATION_HANDLE_VIOLATION, new Expr[]{e, routingContext, Const.of((boolean)forceJsonEncoding)});
            b1.return_();
        });
    }

    private static /* synthetic */ void lambda$generateInvoke$13(BeanInfo btBean, FieldVar rtBean, LocalVar creationalContext, FieldDesc contextField, ClassCreator cc, FieldDesc containerField, BlockCreator b1) {
        if (BuiltinScope.DEPENDENT.is(btBean.getScope())) {
            b1.yield(b1.invokeInterface(Methods.INJECTABLE_REF_PROVIDER_GET, (Expr)rtBean, (Expr)creationalContext));
        } else {
            InstanceFieldVar context;
            if (contextField != null) {
                context = cc.this_().field(contextField);
            } else {
                context = b1.localVar("context", b1.invokeInterface(Methods.ARC_CONTAINER_GET_ACTIVE_CONTEXT, (Expr)cc.this_().field(containerField), b1.invokeInterface(Methods.BEAN_GET_SCOPE, (Expr)rtBean)));
                b1.ifNull((Expr)context, b2 -> b2.throw_(ContextNotActiveException.class, "Context not active: " + String.valueOf(btBean.getScope().getDotName())));
            }
            LocalVar tmp = b1.localVar("tmp", b1.invokeInterface(Methods.CONTEXT_GET_IF_PRESENT, (Expr)context, (Expr)rtBean));
            b1.ifNull((Expr)tmp, arg_0 -> ReactiveRoutesProcessor.lambda$generateInvoke$12(tmp, (Var)context, rtBean, arg_0));
            b1.yield((Expr)tmp);
        }
    }

    private static /* synthetic */ void lambda$generateInvoke$12(LocalVar tmp, Var context, FieldVar rtBean, BlockCreator b2) {
        b2.set((Assignable)tmp, b2.invokeInterface(Methods.CONTEXT_GET, (Expr)context, (Expr)rtBean, b2.new_(Methods.CREATIONAL_CONTEXT_IMPL_CTOR, (Expr)rtBean)));
    }

    static class ParameterInjector {
        final TriPredicate<Type, Set<AnnotationInstance>, IndexView> predicate;
        final ValueProvider provider;
        final Route.HandlerType targetHandlerType;
        final ParamValidator validator;
        final boolean canEndResponse;

        static Builder builder() {
            return new Builder();
        }

        ParameterInjector(final Builder builder) {
            this.predicate = builder.predicate != null ? builder.predicate : new TriPredicate<Type, Set<AnnotationInstance>, IndexView>(){
                final List<Type> matchTypes;
                final List<Type> skipTypes;
                final List<DotName> requiredAnnotationNames;
                {
                    this.matchTypes = builder.matchTypes;
                    this.skipTypes = builder.skipTypes;
                    this.requiredAnnotationNames = builder.requiredAnnotationNames;
                }

                @Override
                public boolean test(Type paramType, Set<AnnotationInstance> paramAnnotations, IndexView index) {
                    if (this.skipTypes != null) {
                        for (Type skipType : this.skipTypes) {
                            if (skipType.kind() != paramType.kind()) continue;
                            if (skipType.kind() == Type.Kind.CLASS && skipType.name().equals((Object)paramType.name())) {
                                return false;
                            }
                            if (skipType.kind() != Type.Kind.PARAMETERIZED_TYPE || !skipType.name().equals((Object)paramType.name()) || !skipType.asParameterizedType().arguments().equals(paramType.asParameterizedType().arguments())) continue;
                            return false;
                        }
                    }
                    if (this.matchTypes != null) {
                        boolean matches = false;
                        for (Type matchType : this.matchTypes) {
                            if (matchType.kind() != paramType.kind()) continue;
                            if (matchType.kind() == Type.Kind.CLASS && matchType.name().equals((Object)paramType.name())) {
                                matches = true;
                                break;
                            }
                            if (matchType.kind() != Type.Kind.PARAMETERIZED_TYPE || !matchType.name().equals((Object)paramType.name()) || !matchType.asParameterizedType().arguments().equals(paramType.asParameterizedType().arguments())) continue;
                            matches = true;
                            break;
                        }
                        if (!matches) {
                            return false;
                        }
                    }
                    if (!this.requiredAnnotationNames.isEmpty()) {
                        for (DotName annotationName : this.requiredAnnotationNames) {
                            if (Annotations.contains(paramAnnotations, (DotName)annotationName)) continue;
                            return false;
                        }
                    }
                    return true;
                }
            };
            this.provider = builder.provider;
            this.targetHandlerType = builder.targetHandlerType;
            this.validator = builder.validator;
            this.canEndResponse = builder.canEndResponse;
        }

        boolean matches(Type paramType, Set<AnnotationInstance> paramAnnotations, IndexView index) {
            return this.predicate.test(paramType, paramAnnotations, index);
        }

        Route.HandlerType getTargetHandlerType() {
            return this.targetHandlerType;
        }

        void validate(BeanInfo bean, MethodInfo method, AnnotationInstance routeInstance, Type paramType, Set<AnnotationInstance> paramAnnotations) {
            if (this.validator != null) {
                this.validator.validate(bean, method, routeInstance, paramType, paramAnnotations);
            }
        }

        LocalVar getValue(MethodParameterInfo methodParam, Set<AnnotationInstance> annotations, Var routingContext, BlockCreator bc, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
            return bc.localVar("value", this.provider.get(methodParam, annotations, routingContext, bc, reflectiveHierarchy));
        }

        static class Builder {
            TriPredicate<Type, Set<AnnotationInstance>, IndexView> predicate;
            List<Type> matchTypes;
            List<Type> skipTypes;
            List<DotName> requiredAnnotationNames = Collections.emptyList();
            ValueProvider provider;
            Route.HandlerType targetHandlerType;
            ParamValidator validator;
            boolean canEndResponse;

            Builder() {
            }

            Builder matchType(DotName className) {
                return this.matchType(Type.create((DotName)className, (Type.Kind)Type.Kind.CLASS));
            }

            Builder matchType(Type type) {
                if (this.matchTypes == null) {
                    this.matchTypes = new ArrayList<Type>();
                }
                this.matchTypes.add(type);
                return this;
            }

            Builder matchPrimitiveWrappers() {
                List<DotName> primitiveNames = List.of(DotName.BOOLEAN_CLASS_NAME, DotName.BYTE_CLASS_NAME, DotName.SHORT_CLASS_NAME, DotName.INTEGER_CLASS_NAME, DotName.LONG_CLASS_NAME, DotName.FLOAT_CLASS_NAME, DotName.DOUBLE_CLASS_NAME, DotName.CHARACTER_CLASS_NAME);
                for (DotName name : primitiveNames) {
                    this.matchType(name);
                    this.matchOptionalOf(name);
                    this.matchListOf(name);
                }
                return this;
            }

            Builder matchOptionalOf(DotName className) {
                return this.matchOptionalOf((Type)ClassType.create((DotName)className));
            }

            Builder matchListOf(DotName className) {
                return this.matchListOf((Type)ClassType.create((DotName)className));
            }

            Builder matchOptionalOf(Type type) {
                return this.matchType((Type)ParameterizedType.builder((DotName)io.quarkus.arc.processor.DotNames.OPTIONAL).addArgument(type).build());
            }

            Builder matchListOf(Type type) {
                return this.matchType((Type)ParameterizedType.builder((DotName)DotNames.LIST).addArgument(type).build());
            }

            Builder skipType(DotName className) {
                return this.skipType((Type)ClassType.create((DotName)className));
            }

            Builder skipType(Type type) {
                if (this.skipTypes == null) {
                    this.skipTypes = new ArrayList<Type>();
                }
                this.skipTypes.add(type);
                return this;
            }

            Builder requireAnnotations(DotName ... names) {
                this.requiredAnnotationNames = Arrays.asList(names);
                return this;
            }

            Builder valueProvider(ValueProvider provider) {
                this.provider = provider;
                return this;
            }

            Builder match(TriPredicate<Type, Set<AnnotationInstance>, IndexView> predicate) {
                this.predicate = predicate;
                return this;
            }

            Builder targetHandlerType(Route.HandlerType handlerType) {
                this.targetHandlerType = handlerType;
                return this;
            }

            Builder validate(ParamValidator validator) {
                this.validator = validator;
                return this;
            }

            Builder canEndResponse() {
                this.canEndResponse = true;
                return this;
            }

            ParameterInjector build() {
                return new ParameterInjector(this);
            }
        }
    }

    @FunctionalInterface
    static interface ValueProvider {
        public Expr get(MethodParameterInfo var1, Set<AnnotationInstance> var2, Var var3, BlockCreator var4, BuildProducer<ReflectiveHierarchyBuildItem> var5);
    }

    private static class ParamAndHeaderProvider
    implements ValueProvider {
        private final DotName annotationName;
        private final MethodDesc multiMapAccessor;
        private final MethodDesc valueAccessor;

        public ParamAndHeaderProvider(DotName annotationName, MethodDesc multiMapAccessor, MethodDesc valueAccessor) {
            this.annotationName = annotationName;
            this.multiMapAccessor = multiMapAccessor;
            this.valueAccessor = valueAccessor;
        }

        @Override
        public Expr get(MethodParameterInfo methodParam, Set<AnnotationInstance> annotations, Var routingContext, BlockCreator b0, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
            String paramName;
            AnnotationValue paramAnnotationValue = Annotations.find(annotations, (DotName)this.annotationName).value();
            String string = paramName = paramAnnotationValue != null ? paramAnnotationValue.asString() : null;
            if (paramName == null || paramName.equals("<<element name>>")) {
                paramName = methodParam.name();
            }
            if (paramName == null) {
                throw new IllegalStateException("Unable to determine the name of parameter #" + methodParam.position() + " of " + String.valueOf(methodParam.method().declaringClass().name()) + "." + methodParam.method().name() + "() - compile the class with debug info enabled (-g) or parameter names recorded (-parameters), or specify the appropriate annotation value");
            }
            Type paramType = methodParam.type();
            LocalVar result = b0.localVar("result", (Expr)Const.ofDefault(Object.class));
            if (paramType.name().equals((Object)DotNames.LIST)) {
                Type wrappedType = (Type)paramType.asParameterizedType().arguments().get(0);
                b0.set((Assignable)result, b0.invokeInterface(Methods.MULTIMAP_GET_ALL, b0.invokeInterface(this.multiMapAccessor, b0.invokeInterface(Methods.REQUEST, (Expr)routingContext)), (Expr)Const.of((String)paramName)));
                if (!wrappedType.name().equals((Object)DotName.STRING_NAME)) {
                    LocalVar results = b0.localVar("results", b0.new_(ConstructorDesc.of(ArrayList.class, (Class[])new Class[]{Integer.TYPE}), b0.withCollection((Expr)result).size()));
                    b0.forEach((Expr)result, (b1, elem) -> {
                        ReactiveRoutesProcessor.convertPrimitiveAndSet(elem, wrappedType, b1, methodParam);
                        b1.withCollection((Expr)results).add((Expr)elem);
                    });
                    b0.set((Assignable)result, (Expr)results);
                }
            } else {
                b0.set((Assignable)result, b0.invokeInterface(this.valueAccessor, b0.invokeInterface(Methods.REQUEST, (Expr)routingContext), (Expr)Const.of((String)paramName)));
                if (paramType.name().equals((Object)io.quarkus.arc.processor.DotNames.OPTIONAL)) {
                    Type wrappedType = (Type)paramType.asParameterizedType().arguments().get(0);
                    if (!wrappedType.name().equals((Object)DotName.STRING_NAME)) {
                        ReactiveRoutesProcessor.convertPrimitiveAndSet(result, wrappedType, b0, methodParam);
                    }
                    b0.set((Assignable)result, b0.invokeStatic(Methods.OPTIONAL_OF_NULLABLE, (Expr)result));
                } else if (!paramType.name().equals((Object)DotName.STRING_NAME)) {
                    ReactiveRoutesProcessor.convertPrimitiveAndSet(result, paramType, b0, methodParam);
                }
            }
            return result;
        }
    }

    @FunctionalInterface
    static interface ParamValidator {
        public void validate(BeanInfo var1, MethodInfo var2, AnnotationInstance var3, Type var4, Set<AnnotationInstance> var5);
    }

    @FunctionalInterface
    static interface TriPredicate<A, B, C> {
        public boolean test(A var1, B var2, C var3);
    }
}

