/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.logstream;

import io.quarkus.arc.Arc;
import io.quarkus.devui.runtime.logstream.LogStreamBroadcaster;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.mutiny.Multi;
import io.vertx.core.json.JsonObject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;

public class LogStreamJsonRPCService {
    private static final org.jboss.logging.Logger LOG = org.jboss.logging.Logger.getLogger(LogStreamJsonRPCService.class);

    @NonBlocking
    public String ping() {
        return "pong";
    }

    @NonBlocking
    public List<JsonObject> history() {
        LogStreamBroadcaster logStreamBroadcaster = (LogStreamBroadcaster)Arc.container().instance(LogStreamBroadcaster.class, new Annotation[0]).get();
        LinkedBlockingQueue<JsonObject> history = logStreamBroadcaster.getHistory();
        return new ArrayList<JsonObject>(history);
    }

    public Multi<JsonObject> streamLog() {
        LogStreamBroadcaster logStreamBroadcaster = (LogStreamBroadcaster)Arc.container().instance(LogStreamBroadcaster.class, new Annotation[0]).get();
        return logStreamBroadcaster.getLogStream();
    }

    @NonBlocking
    public List<JsonObject> getLoggers() {
        LogContext logContext = LogContext.getLogContext();
        ArrayList<JsonObject> values = new ArrayList<JsonObject>();
        Enumeration loggerNames = logContext.getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            String loggerName = (String)loggerNames.nextElement();
            JsonObject jsonObject = this.getLogger(loggerName);
            if (jsonObject == null) continue;
            values.add(jsonObject);
        }
        return values;
    }

    @NonBlocking
    public JsonObject getLogger(String loggerName) {
        LogContext logContext = LogContext.getLogContext();
        if (loggerName != null && !loggerName.isEmpty()) {
            Logger logger = logContext.getLogger(loggerName);
            return JsonObject.of((String)"name", (Object)loggerName, (String)"effectiveLevel", (Object)this.getEffectiveLogLevel(logger), (String)"configuredLevel", (Object)this.getConfiguredLogLevel(logger));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonBlocking
    public JsonObject updateLogLevel(String loggerName, String levelValue) {
        Level level;
        LogContext logContext = LogContext.getLogContext();
        Logger logger = logContext.getLogger(loggerName);
        if (levelValue == null || levelValue.isBlank()) {
            if (logger.getParent() == null) throw new IllegalArgumentException("The level of the root logger cannot be set to null");
            level = logger.getParent().getLevel();
        } else {
            level = Level.parse(levelValue);
        }
        logger.setLevel(level);
        LOG.info((Object)("Log level updated [" + loggerName + "] changed to [" + levelValue + "]"));
        return this.getLogger(loggerName);
    }

    private String getConfiguredLogLevel(Logger logger) {
        Level level = logger.getLevel();
        return level != null ? level.getName() : null;
    }

    private String getEffectiveLogLevel(Logger logger) {
        if (logger == null) {
            return null;
        }
        if (logger.getLevel() != null) {
            return logger.getLevel().getName();
        }
        return this.getEffectiveLogLevel(logger.getParent());
    }
}

