/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.spring.commons;

import io.restassured.http.Cookie;
import io.restassured.http.Cookies;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.internal.http.CharsetExtractor;
import io.restassured.module.spring.commons.HeaderHelper;
import io.restassured.module.spring.commons.ParamLogger;
import io.restassured.module.spring.commons.config.SpecificationConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public final class RequestLogger {
    private RequestLogger() {
    }

    public static void logParamsAndHeaders(final RequestSpecificationImpl reqSpec, String method, String uri, Object[] unnamedPathParams, Map<String, Object> params, Map<String, Object> namedPathParams, Map<String, Object> queryParams, Map<String, Object> formParams, Headers headers, Cookies cookies) {
        reqSpec.setMethod(method);
        reqSpec.path(uri);
        reqSpec.buildUnnamedPathParameterTuples(unnamedPathParams);
        if (params != null) {
            new ParamLogger(params){

                @Override
                protected void logParam(String paramName, Object paramValue) {
                    reqSpec.param(paramName, new Object[]{paramValue});
                }
            }.logParams();
        }
        if (queryParams != null) {
            new ParamLogger(queryParams){

                @Override
                protected void logParam(String paramName, Object paramValue) {
                    reqSpec.queryParam(paramName, new Object[]{paramValue});
                }
            }.logParams();
        }
        if (Objects.nonNull(namedPathParams)) {
            new ParamLogger(namedPathParams){

                @Override
                protected void logParam(String paramName, Object paramValue) {
                    reqSpec.pathParams(paramName, paramValue, new Object[0]);
                }
            }.logParams();
        }
        if (formParams != null) {
            new ParamLogger(formParams){

                @Override
                protected void logParam(String paramName, Object paramValue) {
                    reqSpec.formParam(paramName, new Object[]{paramValue});
                }
            }.logParams();
        }
        if (headers != null) {
            for (Header header : headers) {
                reqSpec.header(header);
            }
        }
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                reqSpec.cookie(cookie);
            }
        }
    }

    public static void logRequestBody(RequestSpecificationImpl reqSpec, Object requestBody, Headers headers, List<Object> multiParts, SpecificationConfig config) {
        if (requestBody != null) {
            if (requestBody instanceof byte[]) {
                reqSpec.body((byte[])requestBody);
            } else if (requestBody instanceof File) {
                String contentType = HeaderHelper.findContentType(headers, multiParts, config);
                RequestLogger.logFileRequestBody(reqSpec, requestBody, contentType);
            } else {
                reqSpec.body(requestBody);
            }
        }
    }

    public static void logFileRequestBody(RequestSpecificationImpl reqSpec, Object requestBody, String contentType) {
        String charset = null;
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            charset = CharsetExtractor.getCharsetFromContentType((String)contentType);
        }
        if (charset == null) {
            charset = Charset.defaultCharset().toString();
        }
        String string = RequestLogger.fileToString((File)requestBody, charset);
        reqSpec.body(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fileToString(File file, String charset) {
        Scanner scanner;
        StringBuilder fileContents = new StringBuilder((int)file.length());
        try {
            scanner = new Scanner(file, charset);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        String lineSeparator = System.getProperty(SystemUtils.LINE_SEPARATOR);
        try {
            while (scanner.hasNextLine()) {
                fileContents.append(scanner.nextLine()).append(lineSeparator);
            }
            String string = fileContents.toString();
            return string;
        }
        finally {
            scanner.close();
        }
    }
}

