/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.version;

import io.smallrye.common.version.BasicVersionScheme;
import io.smallrye.common.version.JpmsVersionScheme;
import io.smallrye.common.version.MavenVersionScheme;
import io.smallrye.common.version.Messages;
import io.smallrye.common.version.VersionIterator;
import io.smallrye.common.version.VersionSyntaxException;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;

public interface VersionScheme
extends Comparator<String> {
    public static final VersionScheme BASIC = new BasicVersionScheme();
    public static final VersionScheme MAVEN = new MavenVersionScheme();
    public static final VersionScheme JPMS = new JpmsVersionScheme();

    @Override
    public int compare(String var1, String var2);

    default public boolean lt(String base, String other) {
        return this.compare(base, other) < 0;
    }

    default public boolean le(String base, String other) {
        return this.compare(base, other) <= 0;
    }

    default public boolean gt(String base, String other) {
        return this.compare(base, other) > 0;
    }

    default public boolean ge(String base, String other) {
        return this.compare(base, other) >= 0;
    }

    default public String min(String a, String b) {
        return this.le(a, b) ? a : b;
    }

    default public String max(String a, String b) {
        return this.ge(a, b) ? a : b;
    }

    default public Predicate<String> whenEquals(String other) {
        return base -> this.equals((String)base, other);
    }

    default public Predicate<String> whenGt(String other) {
        return base -> this.gt((String)base, other);
    }

    default public Predicate<String> whenGe(String other) {
        return base -> this.ge((String)base, other);
    }

    default public Predicate<String> whenLe(String other) {
        return base -> this.le((String)base, other);
    }

    default public Predicate<String> whenLt(String other) {
        return base -> this.lt((String)base, other);
    }

    default public Predicate<String> fromRangeString(String range) {
        return this.fromRangeString(range, 0, range.length());
    }

    default public Predicate<String> fromRangeString(String range, int start, int end) {
        Objects.checkFromToIndex(start, end, range.length());
        return this.parseRange(range, start, end);
    }

    default public boolean equals(String v1, String v2) {
        return this.compare(v1, v2) == 0;
    }

    default public String canonicalize(String original) {
        return this.appendCanonicalized(new StringBuilder(original.length()), original).toString();
    }

    public StringBuilder appendCanonicalized(StringBuilder var1, String var2);

    default public void validate(String version) throws VersionSyntaxException {
        VersionIterator itr = this.iterate(version);
        while (itr.hasNext()) {
            itr.next();
        }
    }

    public VersionIterator iterate(String var1);

    private Predicate<String> parseRange(String range, int start, int end) {
        if (start == end) {
            return this.whenEquals("");
        }
        int cp = range.codePointAt(start);
        int cnt = Character.charCount(cp);
        switch (cp) {
            case 91: {
                return this.parseMinIncl(range, start + cnt, end);
            }
            case 40: {
                return this.parseMinExcl(range, start + cnt, end);
            }
            case 44: {
                return this.parseMore(this.whenEquals(""), range, start + cnt, end);
            }
        }
        return this.parseSingle(range, start + cnt, end);
    }

    private Predicate<String> parseSingle(String range, int start, int end) {
        int cnt;
        int i = start;
        do {
            int cp = range.codePointAt(i);
            cnt = Character.charCount(cp);
            switch (cp) {
                case 44: {
                    return this.parseMore(this.whenEquals(range.substring(start, i)), range, i + cnt, end);
                }
                case 41: 
                case 93: {
                    throw Messages.msg.standaloneVersionCannotBeBound();
                }
            }
        } while ((i += cnt) < end);
        return this.whenEquals(range.substring(start, end));
    }

    private Predicate<String> parseMinIncl(String range, int start, int end) {
        int cnt;
        int i = start;
        do {
            int cp = range.codePointAt(i);
            cnt = Character.charCount(cp);
            switch (cp) {
                case 44: {
                    if (i == start) {
                        throw Messages.msg.inclusiveVersionCannotBeEmpty();
                    }
                    return this.parseRangeMax(this.whenGe(range.substring(start, i)), range, i + cnt, end);
                }
                case 93: {
                    return this.parseMore(this.whenEquals(range.substring(start, i)), range, i + cnt, end);
                }
                case 41: {
                    throw Messages.msg.singleVersionMustBeSurroundedByBrackets(range.substring(start, i + cnt));
                }
            }
        } while ((i += cnt) < end);
        return this.whenGe(range.substring(start, end));
    }

    private Predicate<String> parseMinExcl(String range, int start, int end) {
        int cnt;
        int i = start;
        do {
            int cp = range.codePointAt(i);
            cnt = Character.charCount(cp);
            switch (cp) {
                case 44: {
                    if (i == start) {
                        return this.parseRangeMax(null, range, i + cnt, end);
                    }
                    return this.parseRangeMax(this.whenGt(range.substring(start, i)), range, i + cnt, end);
                }
                case 41: 
                case 93: {
                    throw Messages.msg.singleVersionMustBeSurroundedByBrackets(range.substring(start, i + cnt));
                }
            }
        } while ((i += cnt) < end);
        return this.whenGt(range.substring(start, end));
    }

    private Predicate<String> parseRangeMax(Predicate<String> min, String range, int start, int end) {
        int cnt;
        int i = start;
        do {
            int cp = range.codePointAt(i);
            cnt = Character.charCount(cp);
            switch (cp) {
                case 41: {
                    if (i == start) {
                        return this.parseMore(min, range, i + cnt, end);
                    }
                }
                case 93: {
                    String high = range.substring(start, i);
                    if (min != null && !min.test(high)) {
                        throw Messages.msg.rangeDefiesVersionOrdering(range.substring(start, i + cnt));
                    }
                    Predicate<String> max = cp == 93 ? this.whenLe(high) : this.whenLt(high);
                    return this.parseMore(min == null ? max : min.and(max), range, i + cnt, end);
                }
                case 44: {
                    throw Messages.msg.rangeUnexpected(range.substring(start, i + cnt));
                }
            }
        } while ((i += cnt) < end);
        throw Messages.msg.unboundedRange(range.substring(start, end));
    }

    private Predicate<String> parseMore(Predicate<String> predicate, String range, int start, int end) {
        if (start < end) {
            int cp = range.codePointAt(start);
            int cnt = Character.charCount(cp);
            if (cp == 44) {
                Predicate<String> nextRange = this.parseRange(range, start + cnt, end);
                return predicate == null ? nextRange : predicate.or(nextRange);
            }
            throw Messages.msg.rangeUnexpected(range.substring(start, start + cnt));
        }
        return predicate;
    }
}

