/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class UniCreateFromFuture<T>
extends AbstractUni<T> {
    private final Supplier<? extends Future<? extends T>> supplier;
    private final Duration timeout;

    public UniCreateFromFuture(Supplier<? extends Future<? extends T>> supplier) {
        this(supplier, null);
    }

    public UniCreateFromFuture(Supplier<? extends Future<? extends T>> supplier, Duration timeout) {
        this.supplier = supplier;
        this.timeout = timeout;
    }

    @Override
    public void subscribe(UniSubscriber<? super T> downstream) {
        Future<T> future = this.obtainFuture(downstream);
        if (future == null) {
            return;
        }
        if (future.isDone()) {
            this.dispatchImmediateResult(future, downstream);
        } else {
            this.dispatchDeferredResult(future, downstream);
        }
    }

    private Future<? extends T> obtainFuture(UniSubscriber<? super T> downstream) {
        Future<? extends T> future;
        try {
            future = this.supplier.get();
        }
        catch (Throwable err) {
            downstream.onSubscribe(EmptyUniSubscription.DONE);
            downstream.onFailure(err);
            return null;
        }
        if (future == null) {
            downstream.onSubscribe(EmptyUniSubscription.DONE);
            downstream.onFailure(new NullPointerException("The produced Future is `null`"));
            return null;
        }
        return future;
    }

    private void dispatchImmediateResult(Future<? extends T> future, UniSubscriber<? super T> downstream) {
        T item;
        try {
            item = future.get();
        }
        catch (ExecutionException e) {
            downstream.onSubscribe(EmptyUniSubscription.DONE);
            downstream.onFailure(e.getCause());
            return;
        }
        catch (Throwable err) {
            if (err instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            downstream.onSubscribe(EmptyUniSubscription.DONE);
            downstream.onFailure(err);
            return;
        }
        downstream.onSubscribe(EmptyUniSubscription.DONE);
        downstream.onItem(item);
    }

    private void dispatchDeferredResult(Future<? extends T> future, UniSubscriber<? super T> downstream) {
        AtomicBoolean cancelled = new AtomicBoolean(false);
        downstream.onSubscribe(() -> {
            cancelled.set(true);
            future.cancel(false);
        });
        Infrastructure.getDefaultExecutor().execute(() -> {
            block6: {
                try {
                    Object item = this.timeout != null ? future.get(this.timeout.toMillis(), TimeUnit.MILLISECONDS) : future.get();
                    if (!cancelled.get()) {
                        downstream.onItem(item);
                    }
                }
                catch (ExecutionException e) {
                    if (!cancelled.get()) {
                        downstream.onFailure(e.getCause());
                    }
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (cancelled.get()) break block6;
                    downstream.onFailure(e);
                }
            }
        });
    }
}

