package io.vertx.mutiny.ext.web.client;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.web.client.CachingWebClientOptions;
import io.vertx.ext.web.client.spi.CacheStore;

/**
 * An asynchronous cache aware HTTP / HTTP/2 client called <code>CachingWebClient</code>.
 * <p>
 * This client wraps a {@link io.vertx.mutiny.ext.web.client.WebClient} and makes it cache aware by adding features to it:
 * <ul>
 *   <li>Cache-Control header parsing</li>
 *   <li>Freshness checking</li>
 * </ul>
 * <p>
 * The client honors the following cache headers:
 * <ul>
 *  <li>Cache-Control with the following properties understood:
 *    <ul>
 *      <li>public</li>
 *      <li>private</li>
 *      <li>no-cache</li>
 *      <li>no-store</li>
 *      <li>max-age</li>
 *      <li>s-maxage</li>
 *      <li>stale-if-error</li>
 *      <li>staile-while-revalidate</li>
 *      <li>must-revalidate</li>
 *    </ul>
 *  </li>
 *  <li>Expires</li>
 *  <li>ETag</li>
 *  <li>Vary</li>
 * </ul>
 * <p/>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.CachingWebClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.client.CachingWebClient.class)
public class CachingWebClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<CachingWebClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CachingWebClient((io.vertx.ext.web.client.CachingWebClient) obj),
    CachingWebClient::getDelegate
  );

  private final io.vertx.ext.web.client.CachingWebClient delegate;
  
  public CachingWebClient(io.vertx.ext.web.client.CachingWebClient delegate) {
    this.delegate = delegate;
  }

  public CachingWebClient(Object delegate) {
    this.delegate = (io.vertx.ext.web.client.CachingWebClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  CachingWebClient() {
    this.delegate = null;
  }

  public io.vertx.ext.web.client.CachingWebClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CachingWebClient that = (CachingWebClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param webClient the web client instance
   * @return the created web client
   */
  public static io.vertx.mutiny.ext.web.client.WebClient create(io.vertx.mutiny.ext.web.client.WebClient webClient) { 
    io.vertx.mutiny.ext.web.client.WebClient ret = io.vertx.mutiny.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.CachingWebClient.create(webClient.getDelegate()));
    return ret;
  }

  /**
   * @param webClient the web client instance
   * @param cacheStore the cache adapter
   * @return the created web client
   */
  public static io.vertx.mutiny.ext.web.client.WebClient create(io.vertx.mutiny.ext.web.client.WebClient webClient, io.vertx.ext.web.client.spi.CacheStore cacheStore) { 
    io.vertx.mutiny.ext.web.client.WebClient ret = io.vertx.mutiny.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.CachingWebClient.create(webClient.getDelegate(), cacheStore));
    return ret;
  }

  /**
   * @param webClient the web client instance
   * @param options the caching web client options
   * @return the created web client
   */
  public static io.vertx.mutiny.ext.web.client.WebClient create(io.vertx.mutiny.ext.web.client.WebClient webClient, io.vertx.ext.web.client.CachingWebClientOptions options) { 
    io.vertx.mutiny.ext.web.client.WebClient ret = io.vertx.mutiny.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.CachingWebClient.create(webClient.getDelegate(), options));
    return ret;
  }

  /**
   * @param webClient the web client instance
   * @param cacheStore the cache adapter
   * @param options the caching web client options
   * @return the created web client
   */
  public static io.vertx.mutiny.ext.web.client.WebClient create(io.vertx.mutiny.ext.web.client.WebClient webClient, io.vertx.ext.web.client.spi.CacheStore cacheStore, io.vertx.ext.web.client.CachingWebClientOptions options) { 
    io.vertx.mutiny.ext.web.client.WebClient ret = io.vertx.mutiny.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.CachingWebClient.create(webClient.getDelegate(), cacheStore, options));
    return ret;
  }

  public static  CachingWebClient newInstance(io.vertx.ext.web.client.CachingWebClient arg) {
    return arg != null ? new CachingWebClient(arg) : null;
  }

}
