/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp.fault;

import io.smallrye.reactive.messaging.amqp.AmqpConnector;
import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import io.smallrye.reactive.messaging.amqp.ConnectionHolder;
import io.smallrye.reactive.messaging.amqp.fault.AmqpFailureHandler;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPLogging;
import io.vertx.mutiny.core.Context;
import java.util.concurrent.CompletionStage;

public class AmqpFailStop
implements AmqpFailureHandler {
    private final String channel;
    private final AmqpConnector connector;

    public AmqpFailStop(AmqpConnector connector, String channel) {
        this.connector = connector;
        this.channel = channel;
    }

    @Override
    public <V> CompletionStage<Void> handle(AmqpMessage<V> msg, Context context, Throwable reason) {
        AMQPLogging.log.nackedFailMessage(this.channel);
        this.connector.reportFailure(this.channel, reason);
        return ConnectionHolder.runOnContextAndReportFailure(context, reason, () -> msg.getAmqpMessage().rejected());
    }
}

