/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp.i18n;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="SRMSG", length=5)
public interface AMQPLogging
extends BasicLogger {
    public static final AMQPLogging log = (AMQPLogging)Logger.getMessageLogger(AMQPLogging.class, (String)"io.smallrye.reactive.messaging.amqp");

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=16200, value="Creating AMQP client from bean named '%s'")
    public void createClientFromBean(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16201, value="AMQP broker configured to %s:%d for channel %s")
    public void brokerConfigured(String var1, int var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16202, value="Unable to create client")
    public void unableToCreateClient(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16203, value="AMQP Receiver listening address %s")
    public void receiverListeningAddress(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16204, value="AMQP Receiver error")
    public void receiverError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16205, value="Unable to retrieve messages from AMQP, retrying...")
    public void retrieveMessagesRetrying(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16206, value="Unable to retrieve messages from AMQP, no more retry")
    public void retrieveMessagesNoMoreRetrying(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16207, value="The AMQP message has not been sent, the client is closed")
    public void messageNotSendClientClosed();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16208, value="Unable to send the AMQP message")
    public void unableToSendMessage(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=16209, value="Unable to use the address configured in the message (%s) - the connector is not using an anonymous sender, using %s instead")
    public void unableToUseAddress(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16210, value="The AMQP message to address `%s` has not been sent, the client is closed")
    public void messageToAddressNotSend(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=16211, value="Sending AMQP message to address `%s`")
    public void sendingMessageToAddress(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16212, value="Establishing connection with AMQP broker")
    public void establishingConnection();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16213, value="Connection with AMQP broker established")
    public void connectionEstablished();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16214, value="AMQP Connection failure")
    public void connectionFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16215, value="Unable to connect to the broker, retry will be attempted")
    public void unableToConnectToBroker(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16216, value="Unable to recover from AMQP connection disruption")
    public void unableToRecoverFromConnectionDisruption(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=16217, value="A message sent to channel `%s` has been nacked, ignoring the failure and marking the AMQP message as accepted")
    public void nackedAcceptMessage(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=16218, value="The full ignored failure is")
    public void fullIgnoredFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16219, value="A message sent to channel `%s` has been nacked, rejecting the AMQP message and fail-stop")
    public void nackedFailMessage(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=16220, value="A message sent to channel `%s` has been nacked, ignoring the failure and marking the AMQP message as rejected")
    public void nackedIgnoreMessage(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=16221, value="A message sent to channel `%s` has been nacked, ignoring the failure and marking the AMQP message as released")
    public void nackedReleaseMessage(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=16222, value="Retrieved credits for channel `%s`: %s")
    public void retrievedCreditsForChannel(String var1, long var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=16223, value="No more credit for channel %s, requesting more credits")
    public void noMoreCreditsForChannel(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16224, value="The AMQP message to address `%s` has not been sent, the client is closed")
    public void messageNoSend(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16225, value="Failure reported for channel `%s`, closing client")
    public void failureReported(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=16226, value="A message sent to channel `%s` has been nacked, ignoring the message and marking the AMQP message as modified with `delivery-failed`")
    public void nackedModifiedFailedMessage(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=16227, value="A message sent to channel `%s` has been nacked, ignoring the message and marking the AMQP message as modified with `delivery-failed` and `undeliverable-here`")
    public void nackedModifiedFailedMessageAndUndeliverableHere(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16228, value="Unable to serialize message on channel `%s`, message has been nacked")
    public void serializationFailure(String var1, @Cause Throwable var2);
}

