/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.smallrye.reactive.messaging.kafka.KafkaConnectorCommonConfiguration;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;

public class KafkaConnectorIncomingConfiguration
extends KafkaConnectorCommonConfiguration {
    public KafkaConnectorIncomingConfiguration(Config config) {
        super(config);
        this.validate();
    }

    public String getKeyDeserializer() {
        return this.config.getOptionalValue("key.deserializer", String.class).orElse("org.apache.kafka.common.serialization.StringDeserializer");
    }

    public String getValueDeserializer() {
        return (String)this.config.getOptionalValue("value.deserializer", String.class).orElseThrow(() -> new IllegalArgumentException("The attribute `value.deserializer` on connector 'smallrye-kafka' (channel: " + this.getChannel() + ") must be set"));
    }

    public Integer getFetchMinBytes() {
        return this.config.getOptionalValue("fetch.min.bytes", Integer.class).orElse(Integer.valueOf("1"));
    }

    public Optional<String> getGroupId() {
        return this.config.getOptionalValue("group.id", String.class);
    }

    public Boolean getRetry() {
        return this.config.getOptionalValue("retry", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Integer getRetryAttempts() {
        return this.config.getOptionalValue("retry-attempts", Integer.class).orElse(Integer.valueOf("-1"));
    }

    public Integer getRetryMaxWait() {
        return this.config.getOptionalValue("retry-max-wait", Integer.class).orElse(Integer.valueOf("30"));
    }

    public Boolean getBroadcast() {
        return this.config.getOptionalValue("broadcast", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public String getAutoOffsetReset() {
        return this.config.getOptionalValue("auto.offset.reset", String.class).orElse("latest");
    }

    @Override
    public void validate() {
        super.validate();
        this.getValueDeserializer();
    }
}

