/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.vertx.core.json.JsonObject;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;

public class JsonHelper {
    public static JsonObject asJsonObject(Config config) {
        JsonObject json = new JsonObject();
        Iterable propertyNames = config.getPropertyNames();
        for (String originalKey : propertyNames) {
            Optional d2;
            String key = originalKey.toLowerCase().replace("_", ".");
            try {
                Optional i = config.getOptionalValue(originalKey, Integer.class);
                if (i.isPresent()) {
                    json.put(key, (Integer)i.get());
                    continue;
                }
            }
            catch (ClassCastException | IllegalArgumentException i) {
                // empty catch block
            }
            try {
                d2 = config.getOptionalValue(originalKey, Double.class);
                if (d2.isPresent()) {
                    json.put(key, (Double)d2.get());
                    continue;
                }
            }
            catch (ClassCastException | IllegalArgumentException d2) {
                // empty catch block
            }
            try {
                String value = config.getOptionalValue(originalKey, String.class).orElse("").trim();
                if (value.equalsIgnoreCase("false")) {
                    json.put(key, Boolean.valueOf(false));
                    continue;
                }
                if (value.equalsIgnoreCase("true")) {
                    json.put(key, Boolean.valueOf(true));
                    continue;
                }
                json.put(key, value);
            }
            catch (ClassCastException value) {
                try {
                    d2 = config.getOptionalValue(originalKey, Boolean.class);
                    d2.ifPresent(v -> json.put(key, v));
                }
                catch (ClassCastException | IllegalArgumentException runtimeException) {}
            }
        }
        return json;
    }
}

