/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.kafka.admin.KafkaAdminClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.admin.AdminClientConfig;

public class KafkaAdminHelper {
    private KafkaAdminHelper() {
    }

    public static KafkaAdminClient createAdminClient(Vertx vertx, Map<String, Object> kafkaConfigurationMap, String channel, boolean incoming) {
        HashMap<String, String> copy = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : kafkaConfigurationMap.entrySet()) {
            if (AdminClientConfig.configNames().contains(entry.getKey())) {
                copy.put(entry.getKey(), entry.getValue().toString());
                continue;
            }
            if (!entry.getKey().startsWith("sasl.")) continue;
            copy.put(entry.getKey(), entry.getValue().toString());
        }
        copy.put("client.id", "kafka-admin-" + (incoming ? "incoming-" : "outgoing-") + channel);
        if (!kafkaConfigurationMap.containsKey("reconnect.backoff.max.ms")) {
            copy.put("reconnect.backoff.max.ms", "10000");
        }
        return KafkaAdminClient.create((Vertx)vertx, copy);
    }
}

