/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api;

import io.smallrye.openapi.api.ApiMessages;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;

@FunctionalInterface
public interface OperationIdGenerator {
    public String generateOperationId(ClassInfo var1, MethodInfo var2);

    public static OperationIdGenerator load(String strategyName, ClassLoader loader) {
        OperationIdGenerator strategy;
        switch (strategyName) {
            case "METHOD": {
                strategy = (c, m) -> m.name();
                break;
            }
            case "CLASS_METHOD": {
                strategy = (c, m) -> c.name().withoutPackagePrefix() + "_" + m.name();
                break;
            }
            case "PACKAGE_CLASS_METHOD": {
                strategy = (c, m) -> String.valueOf(c.name()) + "_" + m.name();
                break;
            }
            default: {
                try {
                    Class<?> strategyType = loader.loadClass(strategyName);
                    strategy = (OperationIdGenerator)strategyType.getConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                catch (Exception e) {
                    throw ApiMessages.msg.invalidOperationIdStrategyWithCause(strategyName, e);
                }
            }
        }
        return strategy;
    }
}

