package io.split.client;

import io.codigo.dtos.SDKSettingsDTO;
import io.codigo.dtos.SplitChange;
import io.codigo.models.SDKSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Created by adilaijaz on 8/21/15.
 */
public class HttpSDKSettingsFetcher {
    private static final Logger _log = LoggerFactory.getLogger(HttpSDKSettingsFetcher.class);

    private final WebTarget _target;


    public static HttpSDKSettingsFetcher create(WebTarget root) {
        return new HttpSDKSettingsFetcher(root.path("sdkSettings"));
    }

    private HttpSDKSettingsFetcher(WebTarget target) {
        _target = target;
        checkNotNull(_target);
    }

    public SDKSettings fetch() {

        SDKSettingsDTO result = null;

        try {
            Response response = _target
                    .request(MediaType.APPLICATION_JSON)
                    .get();

            if (response.getStatus() != 200) {
                _log.error("Response status was: " + response.getStatus());
                return result;
            }

            result = response.readEntity(SDKSettingsDTO.class);

            return result;

        } catch (Throwable t) {
            _log.error("Problem reading entity SDKSettings", t);
        }

        return result;

    }
}
