/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.split.client.LocalhostSplitClient;
import io.split.client.LocalhostSplitFile;
import io.split.client.LocalhostSplitManager;
import io.split.client.SplitClient;
import io.split.client.SplitFactory;
import io.split.client.SplitManager;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalhostSplitFactory
implements SplitFactory {
    private static final Logger _log = LoggerFactory.getLogger(LocalhostSplitFactory.class);
    static final String FILENAME = ".split";
    static final String LOCALHOST = "localhost";
    private final LocalhostSplitClient _client;
    private final LocalhostSplitManager _manager;
    private final LocalhostSplitFile _splitFile;

    public static LocalhostSplitFactory createLocalhostSplitFactory() throws IOException {
        String directory = System.getProperty("user.home");
        Preconditions.checkNotNull((Object)directory, (Object)"Property user.home should be set when using environment: localhost");
        return new LocalhostSplitFactory(directory);
    }

    public LocalhostSplitFactory(String directory) throws IOException {
        Preconditions.checkNotNull((Object)directory, (Object)"directory must not be null");
        _log.info("home = " + directory);
        this._splitFile = new LocalhostSplitFile(this, directory, FILENAME);
        Map<String, String> _featureToTreatmentMap = this._splitFile.readOnSplits();
        this._client = new LocalhostSplitClient(this, _featureToTreatmentMap);
        this._manager = new LocalhostSplitManager(_featureToTreatmentMap);
        this._splitFile.registerWatcher();
        this._splitFile.start();
    }

    @Override
    public SplitClient client() {
        return this._client;
    }

    @Override
    public SplitManager manager() {
        return this._manager;
    }

    @Override
    public void destroy() {
        this._client.updateFeatureToTreatmentMap((Map<String, String>)ImmutableMap.of());
        this._splitFile.stopThread();
    }

    public void updateFeatureToTreatmentMap(Map<String, String> featureToTreatmentMap) {
        this._client.updateFeatureToTreatmentMap(featureToTreatmentMap);
        this._manager.updateFeatureToTreatmentMap(featureToTreatmentMap);
    }
}

