/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.clean;

import io.streamthoughts.kafka.connect.filepulse.clean.BatchFileCleanupPolicy;
import io.streamthoughts.kafka.connect.filepulse.clean.FileCleanupPolicy;
import io.streamthoughts.kafka.connect.filepulse.clean.FileCleanupPolicyResult;
import io.streamthoughts.kafka.connect.filepulse.clean.FileCleanupPolicyResultSet;
import io.streamthoughts.kafka.connect.filepulse.fs.Storage;
import io.streamthoughts.kafka.connect.filepulse.source.FileObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DelegateBatchFileCleanupPolicy
implements BatchFileCleanupPolicy {
    private final FileCleanupPolicy delegate;

    public DelegateBatchFileCleanupPolicy(FileCleanupPolicy delegate) {
        Objects.requireNonNull(delegate, "delegate cannot be null");
        this.delegate = delegate;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        this.delegate.configure(configs);
    }

    @Override
    public FileCleanupPolicyResultSet apply(List<FileObject> sources) {
        FileCleanupPolicyResultSet rs = new FileCleanupPolicyResultSet();
        for (FileObject source : sources) {
            if (this.delegate.apply(source).booleanValue()) {
                rs.add(source, FileCleanupPolicyResult.SUCCEED);
                continue;
            }
            rs.add(source, FileCleanupPolicyResult.FAILED);
        }
        return rs;
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    @Override
    public void setStorage(Storage storage) {
        this.delegate.setStorage(storage);
    }
}

