/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.clean;

import io.streamthoughts.kafka.connect.filepulse.clean.FileCleanupPolicyResult;
import io.streamthoughts.kafka.connect.filepulse.internal.KeyValuePair;
import io.streamthoughts.kafka.connect.filepulse.source.FileObject;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.BiConsumer;

public class FileCleanupPolicyResultSet {
    private final Collection<KeyValuePair<FileObject, FileCleanupPolicyResult>> resultSet = new LinkedList<KeyValuePair<FileObject, FileCleanupPolicyResult>>();

    public void add(FileObject source, FileCleanupPolicyResult result) {
        Objects.requireNonNull(source, "source cannot be null");
        Objects.requireNonNull(result, "result cannot be null");
        this.resultSet.add(KeyValuePair.of(source, result));
    }

    public void forEach(BiConsumer<? super FileObject, FileCleanupPolicyResult> action) {
        Objects.requireNonNull(action);
        for (KeyValuePair<FileObject, FileCleanupPolicyResult> kv : this.resultSet) {
            action.accept((FileObject)kv.key, (FileCleanupPolicyResult)((Object)kv.value));
        }
    }
}

