/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.data;

import io.streamthoughts.kafka.connect.filepulse.data.Schema;
import io.streamthoughts.kafka.connect.filepulse.data.SchemaMapper;
import io.streamthoughts.kafka.connect.filepulse.data.SchemaMapperWithValue;
import io.streamthoughts.kafka.connect.filepulse.data.Type;
import java.util.Collection;
import java.util.Objects;

public class ArraySchema
implements Schema {
    private final Type type = Type.ARRAY;
    private final Schema valueSchema;
    private Integer hash;

    ArraySchema(Schema valueSchema) {
        this.valueSchema = valueSchema;
    }

    public Schema valueSchema() {
        return this.valueSchema;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public <T> T map(SchemaMapper<T> mapper, boolean optional) {
        return mapper.map(this, optional);
    }

    @Override
    public <T> T map(SchemaMapperWithValue<T> mapper, Object object, boolean optional) {
        return mapper.map(this, (Collection)object, optional);
    }

    @Override
    public boolean isResolvable() {
        return this.valueSchema.isResolvable();
    }

    @Override
    public Schema merge(Schema o) {
        if (this.equals(o)) {
            return this;
        }
        if (o instanceof ArraySchema) {
            ArraySchema that = (ArraySchema)o;
            if (!this.isResolvable()) {
                return that;
            }
            if (!that.isResolvable()) {
                return this;
            }
            return Schema.array(this.valueSchema().merge(that.valueSchema()));
        }
        return Schema.array(this.valueSchema().merge(o));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArraySchema)) {
            return false;
        }
        ArraySchema that = (ArraySchema)o;
        return this.type == that.type && Objects.equals(this.valueSchema, that.valueSchema);
    }

    public int hashCode() {
        if (this.hash == null) {
            this.hash = Objects.hash(new Object[]{this.type, this.valueSchema});
        }
        return this.hash;
    }

    public String toString() {
        return "[type=" + String.valueOf((Object)this.type()) + ", valueSchema=" + String.valueOf(this.valueSchema) + "]";
    }
}

