/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.data;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FieldPaths {
    private final Set<FieldPath> paths;

    public static FieldPaths empty() {
        return new FieldPaths(Collections.emptySet());
    }

    public static FieldPaths from(Collection<String> paths) {
        return new FieldPaths(paths.stream().map(FieldPath::new).collect(Collectors.toSet()));
    }

    public FieldPaths next(String currentField) {
        return new FieldPaths(this.paths.stream().map(p -> p.forwardIfOrNull(currentField)).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    private FieldPaths(Set<FieldPath> paths) {
        this.paths = paths;
    }

    public boolean anyMatches(String fieldName) {
        return this.paths.stream().anyMatch(it -> it.matches(fieldName));
    }

    public static class FieldPath {
        private final String path;
        private final String field;
        private final String remaining;

        FieldPath(String path) {
            this.path = path;
            if (path.contains(".")) {
                String[] split = path.split("\\.", 2);
                this.field = split[0];
                this.remaining = split[1];
            } else {
                this.field = path;
                this.remaining = null;
            }
        }

        public boolean matches(String field) {
            return this.path.equals(field);
        }

        private FieldPath forwardIfOrNull(String field) {
            if (!this.field.equals(field)) {
                return null;
            }
            if (this.remaining == null) {
                return null;
            }
            return new FieldPath(this.remaining);
        }
    }
}

