/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.data;

import io.streamthoughts.kafka.connect.filepulse.data.ArraySchema;
import io.streamthoughts.kafka.connect.filepulse.data.DataException;
import io.streamthoughts.kafka.connect.filepulse.data.Schema;
import io.streamthoughts.kafka.connect.filepulse.data.SchemaSupplier;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

public class LazyArraySchema
extends ArraySchema
implements Schema {
    private final Collection<?> list;
    private Schema valueSchema;

    LazyArraySchema(Collection<?> list) {
        super(null);
        this.list = list;
    }

    @Override
    public Schema valueSchema() {
        if (this.valueSchema == null) {
            if (this.list.isEmpty()) {
                throw new DataException("Cannot infer value type because LIST is empty");
            }
            Iterator<?> iterator = this.list.iterator();
            this.valueSchema = SchemaSupplier.lazy(iterator.next()).get();
            while (iterator.hasNext()) {
                this.valueSchema = this.valueSchema.merge(SchemaSupplier.lazy(iterator.next()).get());
            }
        }
        return this.valueSchema;
    }

    @Override
    public boolean isResolvable() {
        return this.valueSchema != null || !this.list.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LazyArraySchema that = (LazyArraySchema)o;
        return Objects.equals(this.list, that.list) && Objects.equals(this.valueSchema, that.valueSchema);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type(), this.valueSchema});
    }

    @Override
    public String toString() {
        return "LazyArraySchema{list=" + String.valueOf(this.list) + ", valueSchema=" + String.valueOf(this.valueSchema) + "}";
    }
}

