/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.data;

import io.streamthoughts.kafka.connect.filepulse.data.DataException;
import io.streamthoughts.kafka.connect.filepulse.data.MapSchema;
import io.streamthoughts.kafka.connect.filepulse.data.Schema;
import io.streamthoughts.kafka.connect.filepulse.data.SchemaSupplier;
import java.util.Iterator;
import java.util.Map;

public class LazyMapSchema
extends MapSchema
implements Schema {
    private final Map map;
    private Schema valueSchema;

    LazyMapSchema(Map map) {
        super(null);
        this.map = map;
    }

    @Override
    public Schema valueSchema() {
        if (this.valueSchema == null) {
            if (this.map.isEmpty()) {
                throw new DataException("Cannot infer value type because MAP is empty");
            }
            Iterator iterator = this.map.values().iterator();
            this.valueSchema = SchemaSupplier.lazy(iterator.next()).get();
            while (iterator.hasNext()) {
                this.valueSchema = this.valueSchema.merge(SchemaSupplier.lazy(iterator.next()).get());
            }
        }
        return this.valueSchema;
    }

    @Override
    public boolean isResolvable() {
        return this.valueSchema != null || !this.map.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

