/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.data;

import io.streamthoughts.kafka.connect.filepulse.data.DataException;
import io.streamthoughts.kafka.connect.filepulse.data.Schema;
import io.streamthoughts.kafka.connect.filepulse.data.SchemaMapper;
import io.streamthoughts.kafka.connect.filepulse.data.SchemaMapperWithValue;
import io.streamthoughts.kafka.connect.filepulse.data.Type;
import io.streamthoughts.kafka.connect.filepulse.data.TypedField;
import io.streamthoughts.kafka.connect.filepulse.data.TypedStruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructSchema
implements Schema,
Iterable<TypedField> {
    private static final Logger LOG = LoggerFactory.getLogger(StructSchema.class);
    private final Map<String, TypedField> fields = new LinkedHashMap<String, TypedField>();
    private Integer hash;
    private String name;
    private String namespace;
    private String doc;

    public StructSchema() {
        this(Collections.emptyList(), null);
    }

    public StructSchema(StructSchema schema) {
        this(schema.fields(), schema.name);
        this.namespace = schema.namespace;
        this.doc = schema.doc;
    }

    public StructSchema(Collection<TypedField> fields, String name) {
        this.name = name;
        fields.forEach(field -> this.fields.put(field.name(), (TypedField)field));
    }

    public StructSchema field(String fieldName, Schema fieldSchema) {
        if (fieldName == null || fieldName.isEmpty()) {
            throw new DataException("fieldName cannot be null.");
        }
        if (null == fieldSchema) {
            throw new DataException("fieldSchema for field " + fieldName + " cannot be null.");
        }
        if (this.fields.containsKey(fieldName)) {
            throw new DataException("Cannot create field because of field name duplication " + fieldName);
        }
        this.fields.put(fieldName, new TypedField(this.fields.size(), fieldSchema, fieldName));
        return this;
    }

    int indexOf(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            throw new DataException("fieldName cannot be null.");
        }
        return this.fields.containsKey(fieldName) ? this.fields.get(fieldName).index() : -1;
    }

    public TypedField field(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            throw new DataException("fieldName cannot be null.");
        }
        return this.fields.get(fieldName);
    }

    public List<TypedField> fields() {
        ArrayList<TypedField> ordered = new ArrayList<TypedField>(this.fields.values());
        ordered.sort(Comparator.comparing(TypedField::name));
        return ordered;
    }

    public List<TypedField> fieldsByIndex() {
        ArrayList<TypedField> ordered = new ArrayList<TypedField>(this.fields.values());
        ordered.sort(Comparator.comparing(TypedField::index));
        return ordered;
    }

    void set(String fieldName, Schema fieldSchema) {
        if (fieldName == null || fieldName.isEmpty()) {
            throw new DataException("fieldName cannot be null.");
        }
        if (null == fieldSchema) {
            throw new DataException("fieldSchema for field " + fieldName + " cannot be null.");
        }
        TypedField field = this.field(fieldName);
        if (field == null) {
            throw new DataException("Cannot set field because of field do not exist " + fieldName);
        }
        this.fields.put(fieldName, new TypedField(field.index(), fieldSchema, fieldName));
    }

    void rename(String fieldName, String newField) {
        TypedField tf = this.fields.remove(fieldName);
        if (tf == null) {
            throw new DataException("Cannot rename field because of field do not exist " + fieldName);
        }
        this.fields.put(newField, new TypedField(tf.index(), tf.schema(), newField));
    }

    TypedField remove(String fieldName) {
        TypedField tf = this.field(fieldName);
        if (tf == null) {
            return null;
        }
        this.fields.remove(tf.name());
        this.fields.replaceAll((k, v) -> {
            if (v.index() > tf.index()) {
                return new TypedField(v.index() - 1, v.schema(), v.name());
            }
            return v;
        });
        return tf;
    }

    @Override
    public Iterator<TypedField> iterator() {
        return this.fields().iterator();
    }

    @Override
    public Type type() {
        return Type.STRUCT;
    }

    public String name() {
        return this.name;
    }

    public StructSchema name(String name) {
        this.name = name;
        return this;
    }

    public String namespace() {
        return this.namespace;
    }

    public StructSchema namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String doc() {
        return this.doc;
    }

    public StructSchema doc(String doc) {
        this.doc = doc;
        return this;
    }

    @Override
    public <T> T map(SchemaMapper<T> mapper, boolean optional) {
        return mapper.map(this, optional);
    }

    @Override
    public <T> T map(SchemaMapperWithValue<T> mapper, Object object, boolean optional) {
        return mapper.map(this, (TypedStruct)object, optional);
    }

    @Override
    public Schema merge(Schema o) {
        if (this.equals(o)) {
            return this;
        }
        if (!(o instanceof StructSchema)) {
            return o.merge(this);
        }
        StructSchema that = (StructSchema)o;
        return new StructSchemaMerger().apply(this, that);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StructSchema)) {
            return false;
        }
        StructSchema that = (StructSchema)o;
        return Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        if (this.hash == null) {
            this.hash = Objects.hash(this.fields);
        }
        return this.hash;
    }

    public String toString() {
        return "[fields=" + String.valueOf(this.fields) + "]";
    }

    static class StructSchemaMerger
    implements BiFunction<StructSchema, StructSchema, StructSchema> {
        StructSchemaMerger() {
        }

        @Override
        public StructSchema apply(StructSchema left, StructSchema right) {
            if (!Objects.equals(left.name, right.name)) {
                throw new DataException("Cannot merge two schemas wih different name " + left.name() + "<>" + right.name());
            }
            if (!Objects.equals(left.namespace, right.namespace)) {
                throw new DataException("Cannot merge two schemas wih different namespace " + left.name() + "<>" + right.name());
            }
            LOG.debug("Merging schemas with namespace: {}, name: {}", (Object)left.name, (Object)left.namespace);
            StructSchema merged = new StructSchema().name(left.name).namespace(left.namespace).doc(left.doc);
            HashMap<String, TypedField> remaining = new HashMap<String, TypedField>(left.fields);
            for (TypedField rightField : right.fields()) {
                String name = rightField.name();
                LOG.debug("Merging field: name={}, ", (Object)name);
                if (!remaining.containsKey(name)) {
                    merged.field(name, rightField.schema());
                    continue;
                }
                TypedField leftField = remaining.remove(name);
                try {
                    Schema fieldMergedSchema = leftField.schema().merge(rightField.schema());
                    merged.field(name, fieldMergedSchema);
                }
                catch (Exception e) {
                    throw new DataException("Failed to merge schemas for field '" + name + "'. ", e);
                }
            }
            remaining.values().forEach(it -> merged.field(it.name(), it.schema()));
            return merged;
        }
    }
}

