/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.data;

import io.streamthoughts.kafka.connect.filepulse.data.DataException;
import io.streamthoughts.kafka.connect.filepulse.data.GettableByType;
import io.streamthoughts.kafka.connect.filepulse.data.Schema;
import io.streamthoughts.kafka.connect.filepulse.data.SchemaSupplier;
import io.streamthoughts.kafka.connect.filepulse.data.StructSchema;
import io.streamthoughts.kafka.connect.filepulse.data.Type;
import io.streamthoughts.kafka.connect.filepulse.data.TypedStruct;
import io.streamthoughts.kafka.connect.filepulse.data.internal.TypeConverter;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class TypedValue
implements GettableByType {
    private final Object value;
    private final SchemaSupplier schema;

    public static TypedValue none() {
        return new TypedValue(Schema.none(), null);
    }

    public static TypedValue parse(String text) {
        String trimmed = text.trim();
        if (TypeConverter.isIntegerNumber(trimmed)) {
            if (trimmed.length() <= 19 && TypeConverter.isInLongRange(trimmed)) {
                return TypedValue.int64(Long.parseLong(trimmed));
            }
            return TypedValue.string(text);
        }
        if (TypeConverter.isDoubleNumber(trimmed)) {
            return TypedValue.float64(Double.parseDouble(trimmed));
        }
        if (TypeConverter.isBooleanString(trimmed)) {
            return TypedValue.bool(Boolean.parseBoolean(trimmed));
        }
        return TypedValue.string(text);
    }

    public static TypedValue of(Object value, Schema schema) {
        return new TypedValue(schema, value);
    }

    public static TypedValue of(Object value, Type type) {
        return new TypedValue(Schema.of(type), value);
    }

    public static TypedValue any(Object value) {
        Type supportedType;
        Object supportedValue = value;
        if (value != null && (supportedType = Type.forClass(supportedValue.getClass())) == null) {
            supportedValue = TypeConverter.getString(value);
        }
        return new TypedValue(supportedValue);
    }

    public static TypedValue string(String value) {
        return new TypedValue(Schema.string(), (Object)value);
    }

    public static TypedValue bool(Boolean value) {
        return new TypedValue(Schema.bool(), (Object)value);
    }

    public static TypedValue int16(Short value) {
        return new TypedValue(Schema.int16(), (Object)value);
    }

    public static TypedValue int32(Integer value) {
        return new TypedValue(Schema.int32(), (Object)value);
    }

    public static TypedValue int64(Long value) {
        return new TypedValue(Schema.int64(), (Object)value);
    }

    public static TypedValue float64(Double value) {
        return new TypedValue(Schema.float64(), (Object)value);
    }

    public static TypedValue float32(Float value) {
        return new TypedValue(Schema.float32(), (Object)value);
    }

    public static TypedValue struct(TypedStruct value) {
        return new TypedValue(new StructSchema(value.schema()), (Object)value);
    }

    public static TypedValue map(Map<String, ?> value, Type valueType) {
        return new TypedValue(Schema.map(value, Schema.of(valueType)), value);
    }

    public static TypedValue array(Collection<?> value, Schema valueSchema) {
        return new TypedValue(Schema.array(value, valueSchema), value);
    }

    public static TypedValue array(Collection<?> value, Type valueType) {
        return TypedValue.array(value, Schema.of(valueType));
    }

    public static TypedValue bytes(byte[] value) {
        return new TypedValue(Schema.bytes(), (Object)value);
    }

    public static TypedValue bytes(ByteBuffer value) {
        return new TypedValue(Schema.bytes(), (Object)value.array());
    }

    private TypedValue(Object value) {
        this(SchemaSupplier.lazy(value), value);
    }

    private TypedValue(Schema schema, Object value) {
        this(SchemaSupplier.eager(schema), value);
    }

    private TypedValue(SchemaSupplier schema, Object value) {
        Objects.requireNonNull(schema, "schema cannot null");
        this.value = value;
        this.schema = schema;
    }

    @Override
    public <K, V> Map<K, V> getMap() throws DataException {
        return (Map)this.value;
    }

    public <T> T value() {
        return (T)this.value;
    }

    @Override
    public <T> Collection<T> getArray() throws DataException {
        return TypeConverter.getArray(this.value);
    }

    @Override
    public Boolean getBool() throws DataException {
        return TypeConverter.getBool(this.value);
    }

    @Override
    public Integer getInt() throws DataException {
        return TypeConverter.getInt(this.value);
    }

    @Override
    public Short getShort() throws DataException {
        return TypeConverter.getShort(this.value);
    }

    @Override
    public Long getLong() throws DataException {
        return TypeConverter.getLong(this.value);
    }

    @Override
    public Float getFloat() throws DataException {
        return TypeConverter.getFloat(this.value);
    }

    @Override
    public Double getDouble() throws DataException {
        return TypeConverter.getDouble(this.value);
    }

    @Override
    public Date getDate() throws DataException {
        return TypeConverter.getDate(this.value);
    }

    @Override
    public String getString() throws DataException {
        return TypeConverter.getString(this.value);
    }

    @Override
    public byte[] getBytes() throws DataException {
        return TypeConverter.getBytes(this.value);
    }

    @Override
    public TypedStruct getStruct() throws DataException {
        return (TypedStruct)this.value;
    }

    public Type type() {
        return this.schema.get().type();
    }

    public Schema schema() {
        return this.schema.get();
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isNotNull() {
        return this.value != null;
    }

    public boolean isEmpty() {
        Type type = this.schema.get().type();
        if (Type.STRING == type) {
            return this.getString().isEmpty();
        }
        if (Type.MAP == type) {
            return this.getMap().isEmpty();
        }
        if (Type.ARRAY == type) {
            return this.getArray().isEmpty();
        }
        if (Type.STRUCT == type) {
            return this.getStruct().schema().fields().isEmpty();
        }
        throw new DataException("Cannot check empty-value on non-string, non-array, non-struct, and non-map type");
    }

    public TypedValue as(Type type) {
        Object converted = this.isNull() ? null : type.convert(this.value);
        return TypedValue.of(converted, type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypedValue)) {
            return false;
        }
        TypedValue typeValue = (TypedValue)o;
        return Objects.equals(this.value, typeValue.value) && Objects.equals(this.schema, typeValue.schema);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.schema);
    }

    public String toString() {
        return "[value=" + String.valueOf(this.value) + ", schema =" + String.valueOf(this.schema) + "]";
    }
}

