/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.filter;

import io.streamthoughts.kafka.connect.filepulse.filter.FilterContext;
import io.streamthoughts.kafka.connect.filepulse.filter.FilterError;
import io.streamthoughts.kafka.connect.filepulse.filter.InternalFilterContext;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import io.streamthoughts.kafka.connect.filepulse.source.FileRecordOffset;
import io.streamthoughts.kafka.connect.filepulse.source.TimestampedRecordOffset;
import java.util.Map;
import org.apache.kafka.connect.header.ConnectHeaders;

public class FilterContextBuilder {
    private FilterError error;
    private FileObjectMeta metadata;
    private FileRecordOffset offset;
    private String topic;
    private Integer partition;
    private Long timestamp;
    private String key;
    private ConnectHeaders headers;
    private Map<String, Object> variables;

    static FilterContextBuilder newBuilder() {
        return new FilterContextBuilder();
    }

    static FilterContextBuilder newBuilder(FilterContext original) {
        return new FilterContextBuilder().withTopic(original.topic()).withKey(original.key()).withPartition(original.partition()).withOffset(original.offset()).withTimestamp(original.timestamp()).withMetadata(original.metadata()).withOffset(original.offset()).withVariables(original.variables()).withHeaders(original.headers()).withError(original.error());
    }

    FilterContextBuilder withVariables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    FilterContextBuilder withTopic(String topic) {
        this.topic = topic;
        return this;
    }

    FilterContextBuilder withPartition(Integer partition) {
        this.partition = partition;
        return this;
    }

    FilterContextBuilder withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    FilterContextBuilder withKey(String key) {
        this.key = key;
        return this;
    }

    FilterContextBuilder withHeaders(ConnectHeaders headers) {
        this.headers = headers;
        return this;
    }

    FilterContextBuilder withMetadata(FileObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    FilterContextBuilder withOffset(FileRecordOffset offset) {
        this.offset = offset;
        return this;
    }

    FilterContextBuilder withError(FilterError exception) {
        this.error = exception;
        return this;
    }

    public FilterContext build() {
        if (this.timestamp == null && this.offset instanceof TimestampedRecordOffset) {
            this.timestamp = ((TimestampedRecordOffset)this.offset).timestamp();
        }
        return new InternalFilterContext(this.metadata, this.offset, this.topic, this.partition, this.timestamp, this.key, this.headers, this.error, this.variables);
    }
}

