/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.filter;

import io.streamthoughts.kafka.connect.filepulse.filter.FilterException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;

public class FilterError {
    private final String exceptionMessage;
    private final String exceptionClassName;
    private final String exceptionStacktrace;
    private final String filter;

    public static FilterError of(Throwable throwable, String filter) {
        Throwable cause = throwable instanceof FilterException && throwable.getCause() != null ? throwable.getCause() : throwable;
        return new FilterError(cause.getMessage(), cause.getClass().getName(), FilterError.getStacktrace(cause), filter);
    }

    public FilterError(String message, String classname, String stacktrace, String filter) {
        this.exceptionMessage = Objects.requireNonNull(message, "'message' should not be null");
        this.exceptionClassName = Objects.requireNonNull(classname, "'classname' should not be null");
        this.exceptionStacktrace = Objects.requireNonNull(stacktrace, "'stacktrace' should not be null");
        this.filter = Objects.requireNonNull(filter, "'filter' should not be null");
    }

    public String filter() {
        return this.filter;
    }

    public String exceptionMessage() {
        return this.exceptionMessage;
    }

    public String exceptionStacktrace() {
        return this.exceptionStacktrace;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterError that = (FilterError)o;
        return Objects.equals(this.exceptionMessage, that.exceptionMessage) && Objects.equals(this.exceptionClassName, that.exceptionClassName) && Objects.equals(this.exceptionStacktrace, that.exceptionStacktrace) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.exceptionMessage, this.exceptionClassName, this.exceptionStacktrace, this.filter);
    }

    private static String getStacktrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }
}

