/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.filter;

import io.streamthoughts.kafka.connect.filepulse.data.TypedStruct;
import io.streamthoughts.kafka.connect.filepulse.filter.FilterContext;
import io.streamthoughts.kafka.connect.filepulse.filter.FilterError;
import io.streamthoughts.kafka.connect.filepulse.internal.Environment;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import io.streamthoughts.kafka.connect.filepulse.source.FileRecordOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.header.ConnectHeaders;

public class InternalFilterContext
extends Environment
implements FilterContext {
    private final ConnectHeaders headers;
    private final FileObjectMeta metadata;
    private final FilterError exception;
    private final FileRecordOffset offset;
    private String topic;
    private Integer partition;
    private final Long timestamp;
    private TypedStruct value;
    private String key;
    private final Map<String, Object> variables;

    InternalFilterContext(FileObjectMeta metadata, FileRecordOffset offset, String topic, Integer partition, Long timestamp, String key, ConnectHeaders headers, FilterError exception, Map<String, Object> variables) {
        Objects.requireNonNull(metadata, "metadata can't be null");
        Objects.requireNonNull(offset, "offset can't be null");
        this.metadata = metadata;
        this.offset = offset;
        this.topic = topic;
        this.partition = partition;
        this.timestamp = timestamp;
        this.key = key;
        this.exception = exception;
        this.headers = headers == null ? new ConnectHeaders() : headers;
        this.variables = variables == null ? new HashMap<String, Object>() : new HashMap<String, Object>(variables);
    }

    @Override
    public FileObjectMeta metadata() {
        return this.metadata;
    }

    @Override
    public FileRecordOffset offset() {
        return this.offset;
    }

    @Override
    public ConnectHeaders headers() {
        return this.headers;
    }

    @Override
    public Integer partition() {
        return this.partition;
    }

    public void setPartition(Integer partition) {
        this.partition = partition;
    }

    @Override
    public String topic() {
        return this.topic;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Long timestamp() {
        return this.timestamp;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public TypedStruct value() {
        return this.value;
    }

    public void setValue(TypedStruct value) {
        this.value = value;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Override
    public FilterError error() {
        return this.exception;
    }

    @Override
    public Map<String, Object> variables() {
        return this.variables;
    }
}

