/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.source;

import io.streamthoughts.kafka.connect.filepulse.source.FileObjectKey;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectOffset;
import java.util.Objects;

public final class FileObjectContext {
    private final FileObjectKey key;
    private final FileObjectMeta metadata;
    private final FileObjectOffset offset;

    public FileObjectContext(FileObjectMeta metadata) {
        this(null, metadata);
    }

    public FileObjectContext(FileObjectKey key, FileObjectMeta metadata) {
        this(key, metadata, FileObjectOffset.empty());
    }

    public FileObjectContext(FileObjectKey key, FileObjectMeta metadata, FileObjectOffset offset) {
        this.metadata = Objects.requireNonNull(metadata, "metadata can't be null");
        this.offset = Objects.requireNonNull(offset, "startPosition can't be null");
        this.key = key;
    }

    public FileObjectMeta metadata() {
        return this.metadata;
    }

    public FileObjectOffset offset() {
        return this.offset;
    }

    public FileObjectKey key() {
        return this.key;
    }

    public FileObjectContext withOffset(FileObjectOffset offset) {
        return new FileObjectContext(this.key, this.metadata, offset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileObjectContext)) {
            return false;
        }
        FileObjectContext that = (FileObjectContext)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.metadata, this.offset);
    }

    public String toString() {
        return "[partition=" + String.valueOf(this.key) + ", metadata=" + String.valueOf(this.metadata) + ", offset=" + String.valueOf(this.offset) + "]";
    }
}

