/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.source;

import com.jsoniter.annotation.JsonCreator;
import com.jsoniter.annotation.JsonProperty;
import io.streamthoughts.kafka.connect.filepulse.internal.Network;
import java.io.Serializable;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.connect.header.ConnectHeaders;

public interface FileObjectMeta
extends Serializable,
Comparable<FileObjectMeta> {
    @JsonProperty(value="uri")
    public URI uri();

    default public String stringURI() {
        return this.uri().toString();
    }

    @JsonProperty(value="name")
    public String name();

    @JsonProperty(value="contentLength")
    public Long contentLength();

    @JsonProperty(value="lastModified")
    public Long lastModified();

    @JsonProperty(value="contentDigest")
    public ContentDigest contentDigest();

    @JsonProperty(value="userDefinedMetadata")
    public Map<String, Object> userDefinedMetadata();

    default public ConnectHeaders toConnectHeader() {
        ConnectHeaders headers = new ConnectHeaders();
        headers.addString("connect.file.name", this.name());
        headers.addString("connect.file.uri", this.uri().toString());
        Optional.ofNullable(this.contentLength()).ifPresent(val -> headers.addLong("connect.file.contentLength", val.longValue()));
        Optional.ofNullable(this.lastModified()).ifPresent(val -> headers.addLong("connect.file.lastModified", val.longValue()));
        this.userDefinedMetadata().forEach((k, v) -> {
            if (v != null) {
                headers.addString("connect.file." + k, v.toString());
            }
        });
        headers.addString("connect.task.hostname", Network.HOSTNAME);
        if (this.contentDigest() != null) {
            headers.addString("connect.file.hash.digest", this.contentDigest().digest());
            headers.addString("connect.file.hash.algorithm", this.contentDigest().algorithm());
        }
        return headers;
    }

    @Override
    default public int compareTo(FileObjectMeta that) {
        return Long.compare(this.lastModified(), that.lastModified());
    }

    public static class ContentDigest {
        private final String digest;
        private final String algorithm;

        @JsonCreator
        public ContentDigest(@JsonProperty(value="digest") String digest, @JsonProperty(value="algorithm") String algorithm) {
            this.digest = Objects.requireNonNull(digest, "'digest' should not be null");
            this.algorithm = Objects.requireNonNull(algorithm, "'algorithm' should not be null").toUpperCase(Locale.getDefault());
        }

        @JsonProperty(value="digest")
        public String digest() {
            return this.digest;
        }

        @JsonProperty(value="algorithm")
        public String algorithm() {
            return this.algorithm;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContentDigest)) {
                return false;
            }
            ContentDigest that = (ContentDigest)o;
            return Objects.equals(this.digest, that.digest) && Objects.equals(this.algorithm, that.algorithm);
        }

        public int hashCode() {
            return Objects.hash(this.digest, this.algorithm);
        }

        public String toString() {
            return "[digest=" + this.digest + ", algorithm='" + this.algorithm + "']";
        }
    }
}

