/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.source;

import com.jsoniter.annotation.JsonCreator;
import com.jsoniter.annotation.JsonProperty;
import java.util.Objects;

public class FileObjectOffset {
    private final long position;
    private final long rows;
    private final long timestamp;

    public static FileObjectOffset empty() {
        return new FileObjectOffset(-1L, 0L, System.currentTimeMillis());
    }

    @JsonCreator
    public FileObjectOffset(@JsonProperty(value="position") long position, @JsonProperty(value="rows") long rows, @JsonProperty(value="timestamp") long timestamp) {
        this.position = position;
        this.rows = rows;
        this.timestamp = timestamp;
    }

    public long position() {
        return this.position;
    }

    public long rows() {
        return this.rows;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileObjectOffset)) {
            return false;
        }
        FileObjectOffset that = (FileObjectOffset)o;
        return this.position == that.position && this.rows == that.rows && this.timestamp == that.timestamp;
    }

    public int hashCode() {
        return Objects.hash(this.position, this.rows, this.timestamp);
    }

    public String toString() {
        return "[position=" + this.position + ", rows=" + this.rows + ", timestamp=" + this.timestamp + "]";
    }
}

