/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.source.internal;

import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import io.streamthoughts.kafka.connect.filepulse.source.InvalidRecordException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.source.SourceRecord;

public class InternalSourceRecordBuilder {
    private String topic;
    private Integer partition;
    private Supplier<SchemaAndValue> keySupplier;
    private Supplier<SchemaAndValue> valueSupplier;
    private Long timestamp;
    private ConnectHeaders additionalHeaders;

    public SourceRecord build(Map<String, ?> sourcePartition, Map<String, ?> sourceOffset, FileObjectMeta metadata, String defaultTopic, Integer defaultPartition) {
        SchemaAndValue value;
        Objects.requireNonNull(sourcePartition, "sourcePartition cannot be null");
        Objects.requireNonNull(sourceOffset, "sourceOffset cannot be null");
        Objects.requireNonNull(metadata, "metadata cannot be null");
        SchemaAndValue key = this.keySupplier != null ? this.keySupplier.get() : null;
        SchemaAndValue schemaAndValue = value = this.valueSupplier != null ? this.valueSupplier.get() : null;
        if (key == null && value == null) {
            throw new InvalidRecordException("key and value cannot be both null");
        }
        ConnectHeaders headers = metadata.toConnectHeader();
        if (this.additionalHeaders != null) {
            this.additionalHeaders.forEach(arg_0 -> ((ConnectHeaders)headers).add(arg_0));
        }
        return new SourceRecord(sourcePartition, sourceOffset, this.topic != null ? this.topic : defaultTopic, this.partition != null ? this.partition : defaultPartition, key != null ? key.schema() : null, key != null ? key.value() : null, value != null ? value.schema() : null, value != null ? value.value() : null, this.timestamp, (Iterable)headers);
    }

    public String topic() {
        return this.topic;
    }

    public Integer partition() {
        return this.partition;
    }

    public void withValue(Supplier<SchemaAndValue> valueSupplier) {
        this.valueSupplier = valueSupplier;
    }

    public void withKey(Supplier<SchemaAndValue> keySupplier) {
        this.keySupplier = keySupplier;
    }

    public void withTopic(String topic) {
        this.topic = topic;
    }

    public void withPartition(Integer partition) {
        this.partition = partition;
    }

    public void withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public void withHeaders(ConnectHeaders headers) {
        this.additionalHeaders = headers;
    }
}

