/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.storage;

import io.streamthoughts.kafka.connect.filepulse.storage.Callback;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class ConvertingFutureCallback<U, T>
implements Callback<U>,
Future<T> {
    private final Callback<T> underlying;
    private final CountDownLatch finishedLatch;
    private T result = null;
    private Throwable exception = null;

    ConvertingFutureCallback(Callback<T> underlying) {
        this.underlying = underlying;
        this.finishedLatch = new CountDownLatch(1);
    }

    protected abstract T convert(U var1);

    @Override
    public void onCompletion(Throwable error, U result) {
        this.exception = error;
        this.result = this.convert(result);
        if (this.underlying != null) {
            this.underlying.onCompletion(error, this.result);
        }
        this.finishedLatch.countDown();
    }

    @Override
    public boolean cancel(boolean b) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.finishedLatch.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.finishedLatch.await();
        return this.result();
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.finishedLatch.await(l, timeUnit)) {
            throw new TimeoutException("Timed out waiting for future");
        }
        return this.result();
    }

    private T result() throws ExecutionException {
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }
}

