/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.storage;

import io.streamthoughts.kafka.connect.filepulse.internal.KafkaUtils;
import io.streamthoughts.kafka.connect.filepulse.storage.Callback;
import io.streamthoughts.kafka.connect.filepulse.storage.KafkaBasedLog;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;

class KafkaBasedLogFactory {
    private final Map<String, ?> producerConfigs;
    private final Map<String, ?> consumerConfigs;

    KafkaBasedLogFactory(Map<String, ?> producerConfigs, Map<String, ?> consumerConfigs) {
        this.producerConfigs = Collections.unmodifiableMap(producerConfigs);
        this.consumerConfigs = Collections.unmodifiableMap(consumerConfigs);
    }

    KafkaBasedLog<String, byte[]> make(String topic, Callback<ConsumerRecord<String, byte[]>> consumedCallback) {
        return new KafkaBasedLog<String, byte[]>(topic, this.newProducerConfigs(), this.newConsumerConfigs(), consumedCallback, Time.SYSTEM, null);
    }

    private Map<String, Object> newConsumerConfigs() {
        Map<String, Object> clientProps = KafkaUtils.getConsumerConfigs(this.consumerConfigs);
        clientProps.put("key.deserializer", StringDeserializer.class.getName());
        clientProps.put("value.deserializer", ByteArrayDeserializer.class.getName());
        return clientProps;
    }

    private Map<String, Object> newProducerConfigs() {
        Map<String, Object> clientProps = KafkaUtils.getProducerConfigs(this.producerConfigs);
        clientProps.put("key.serializer", StringSerializer.class.getName());
        clientProps.put("value.serializer", ByteArraySerializer.class.getName());
        clientProps.put("retries", Integer.MAX_VALUE);
        return clientProps;
    }
}

