/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression;

import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.AbstractExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.EvaluationContext;
import io.streamthoughts.kafka.connect.filepulse.expression.converter.Converters;
import io.streamthoughts.kafka.connect.filepulse.expression.converter.PropertyConverter;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunctionExecutor;
import java.util.List;

public class FunctionExpression
extends AbstractExpression {
    private final ExpressionFunctionExecutor functionExecutor;

    public FunctionExpression(String originalExpression, ExpressionFunctionExecutor functionExecutor) {
        super(originalExpression);
        this.functionExecutor = functionExecutor;
    }

    public TypedValue readValue(EvaluationContext context) {
        return this.readValue(context, TypedValue.class);
    }

    @Override
    public <T> T readValue(EvaluationContext context, Class<T> expectedType) {
        TypedValue evaluated = this.functionExecutor.execute(context);
        if (evaluated != null && expectedType.isAssignableFrom(evaluated.getClass())) {
            return (T)evaluated;
        }
        List<PropertyConverter> converters = context.getPropertyConverter();
        return Converters.converts(converters, evaluated, expectedType);
    }

    @Override
    public void writeValue(Object value, EvaluationContext context) {
        throw new UnsupportedOperationException("functional expression cannot be used to write value");
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    public ExpressionFunctionExecutor getFunctionExecutor() {
        return this.functionExecutor;
    }

    public String toString() {
        return "[originalExpression=" + this.originalExpression() + ", function=" + String.valueOf(this.functionExecutor) + "]";
    }
}

