/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression;

import io.streamthoughts.kafka.connect.filepulse.expression.AbstractExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.EvaluationContext;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.PropertyAccessors;
import io.streamthoughts.kafka.connect.filepulse.expression.converter.Converters;
import io.streamthoughts.kafka.connect.filepulse.expression.converter.PropertyConverter;
import java.util.List;
import java.util.Objects;

public class PropertyExpression
extends AbstractExpression {
    private final String rootObject;
    private final String attribute;

    public PropertyExpression(String original, String rootObject, String attribute) {
        super(original);
        this.rootObject = Objects.requireNonNull(rootObject, "rootObject cannot be null");
        this.attribute = attribute;
    }

    @Override
    public Object readValue(EvaluationContext context) {
        return this.readValue(context, Object.class);
    }

    public String getRootObject() {
        return this.rootObject;
    }

    public String getAttribute() {
        return this.attribute;
    }

    @Override
    public <T> T readValue(EvaluationContext context, Class<T> expectedType) {
        Objects.requireNonNull(context, " context cannot be null");
        Objects.requireNonNull(expectedType, " expectedType cannot be null");
        PropertyAccessors accessors = new PropertyAccessors(context);
        Object returned = accessors.readPropertyValue(context.rootObject(), this.rootObject);
        if (this.attribute != null) {
            if (returned == null) {
                throw new ExpressionException("Cannot evaluate attribute expression '" + this.attribute + "', root object '" + this.rootObject + "' returned null.");
            }
            returned = accessors.readPropertyValue(returned, this.attribute);
        }
        if (returned != null && expectedType.isAssignableFrom(returned.getClass())) {
            return (T)returned;
        }
        List<PropertyConverter> converters = context.getPropertyConverter();
        return Converters.converts(converters, returned, expectedType);
    }

    @Override
    public void writeValue(Object value, EvaluationContext context) {
        Object target = context.rootObject();
        PropertyAccessors accessors = new PropertyAccessors(context);
        if (this.attribute == null) {
            accessors.writeValueForProperty(target, this.rootObject, value);
        } else {
            Object returned = accessors.readPropertyValue(target, this.rootObject);
            if (returned == null) {
                throw new ExpressionException("Cannot evaluate attribute expression '" + this.attribute + "', root object '" + this.rootObject + "' returned null.");
            }
            accessors.writeValueForProperty(returned, this.attribute, value);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyExpression)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PropertyExpression that = (PropertyExpression)o;
        return Objects.equals(this.rootObject, that.rootObject) && Objects.equals(this.attribute, that.attribute);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rootObject, this.attribute);
    }

    public String toString() {
        return "[originalExpression=" + this.originalExpression() + ", rootObject=" + this.rootObject + ", attribute=" + this.attribute + "]";
    }
}

