/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression;

import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.AbstractExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.EvaluationContext;
import io.streamthoughts.kafka.connect.filepulse.expression.converter.Converters;
import io.streamthoughts.kafka.connect.filepulse.expression.converter.PropertyConverter;
import java.util.List;
import java.util.Objects;

public class ValueExpression
extends AbstractExpression {
    private final Object value;

    public static ValueExpression of(String originalExpression) {
        return new ValueExpression(originalExpression, originalExpression);
    }

    public ValueExpression(String originalExpression, Object value) {
        super(originalExpression);
        this.value = value;
    }

    public TypedValue readValue(EvaluationContext context) {
        return this.value();
    }

    @Override
    public <T> T readValue(EvaluationContext context, Class<T> expectedType) {
        if (this.value == null) {
            return null;
        }
        if (expectedType == String.class) {
            return (T)this.value().getString();
        }
        List<PropertyConverter> converters = context.getPropertyConverter();
        return Converters.converts(converters, this.value, expectedType);
    }

    public TypedValue value() {
        return TypedValue.any((Object)this.value);
    }

    @Override
    public void writeValue(Object value, EvaluationContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValueExpression)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValueExpression that = (ValueExpression)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    public String toString() {
        return this.value().getString();
    }
}

