/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.accessor;

import io.streamthoughts.kafka.connect.filepulse.data.Type;
import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.EvaluationContext;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.AccessException;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.PropertyAccessor;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.header.Header;

public class HeadersAccessor
implements PropertyAccessor {
    @Override
    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{ConnectHeaders.class};
    }

    @Override
    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        return true;
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        ConnectHeaders headers = (ConnectHeaders)target;
        Iterator it = headers.allWithName(name);
        List values = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false).map(Header::value).collect(Collectors.toList());
        return TypedValue.array(values, (Type)Type.STRING);
    }

    @Override
    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        ConnectHeaders headers = (ConnectHeaders)target;
        headers.add(name, new SchemaAndValue(null, newValue));
    }

    @Override
    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return true;
    }
}

