/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.accessor;

import io.streamthoughts.kafka.connect.filepulse.expression.EvaluationContext;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.AccessException;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.PropertyAccessor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class PropertyAccessors {
    private final EvaluationContext context;

    public PropertyAccessors(EvaluationContext context) {
        this.context = Objects.requireNonNull(context, "'context' should not be null");
    }

    public void writeValueForProperty(Object target, String name, Object newValue) throws AccessException {
        List<PropertyAccessor> specificAccessors = this.findSpecificAccessorsToWrite(target, name);
        if (!specificAccessors.isEmpty() && this.evaluateWriters(target, name, newValue, specificAccessors).booleanValue()) {
            return;
        }
        List<PropertyAccessor> genericAccessors = this.findGenericAccessorsToWrite(target, name);
        if (!genericAccessors.isEmpty() && this.evaluateWriters(target, name, newValue, genericAccessors).booleanValue()) {
            return;
        }
        if (specificAccessors.isEmpty() && genericAccessors.isEmpty()) {
            throw new AccessException(String.format("Can't found any property accessor for type '%s' and property %s", target.getClass().getCanonicalName(), name));
        }
    }

    public Object readPropertyValue(Object target, String name) throws AccessException {
        Object value;
        List<PropertyAccessor> specificAccessors = this.findSpecificAccessorsToRead(target, name);
        if (!specificAccessors.isEmpty() && (value = this.evaluateReaders(target, name, specificAccessors)) != null) {
            return value;
        }
        List<PropertyAccessor> genericAccessors = this.findGenericAccessorsToRead(target, name);
        if (!genericAccessors.isEmpty()) {
            return this.evaluateReaders(target, name, genericAccessors);
        }
        throw new AccessException(String.format("Cannot found any property accessor for type '%s' and property %s", target.getClass().getCanonicalName(), name));
    }

    private Boolean evaluateWriters(Object target, String name, Object newValue, List<PropertyAccessor> specifics) {
        Iterator<PropertyAccessor> it = specifics.iterator();
        boolean run = false;
        while (it.hasNext() && !run) {
            PropertyAccessor accessor = it.next();
            accessor.write(this.context, target, name, newValue);
            run = true;
        }
        return run;
    }

    private Object evaluateReaders(Object target, String name, List<PropertyAccessor> specifics) {
        Iterator<PropertyAccessor> it = specifics.iterator();
        Object value = null;
        while (it.hasNext() && value == null) {
            PropertyAccessor accessor = it.next();
            value = accessor.read(this.context, target, name);
        }
        return value;
    }

    public List<PropertyAccessor> findGenericAccessorsToWrite(Object target, String name) {
        return this.context.getPropertyAccessors().stream().filter(accessor -> !PropertyAccessors.isSpecificAccessor(accessor)).filter(accessor -> accessor.canWrite(this.context, target, name)).collect(Collectors.toList());
    }

    public List<PropertyAccessor> findSpecificAccessorsToWrite(Object target, String name) {
        Class<?> type = target instanceof Class ? (Class<?>)target : target.getClass();
        return this.context.getPropertyAccessors().stream().filter(accessor -> PropertyAccessors.isAccessorSpecificForType(type, accessor)).filter(accessor -> accessor.canWrite(this.context, target, name)).collect(Collectors.toList());
    }

    public List<PropertyAccessor> findGenericAccessorsToRead(Object target, String name) {
        return this.context.getPropertyAccessors().stream().filter(accessor -> !PropertyAccessors.isSpecificAccessor(accessor)).filter(accessor -> accessor.canRead(this.context, target, name)).collect(Collectors.toList());
    }

    public List<PropertyAccessor> findSpecificAccessorsToRead(Object target, String name) {
        Class<?> type = target instanceof Class ? (Class<?>)target : target.getClass();
        return this.context.getPropertyAccessors().stream().filter(accessor -> PropertyAccessors.isAccessorSpecificForType(type, accessor)).filter(accessor -> accessor.canRead(this.context, target, name)).collect(Collectors.toList());
    }

    private static boolean isAccessorSpecificForType(Class<?> type, PropertyAccessor accessor) {
        if (PropertyAccessors.isSpecificAccessor(accessor)) {
            Class<?>[] specificTargetClasses = accessor.getSpecificTargetClasses();
            List l = Arrays.stream(specificTargetClasses).filter(clazz -> clazz.isAssignableFrom(type)).collect(Collectors.toList());
            return l.size() > 0;
        }
        return false;
    }

    private static boolean isSpecificAccessor(PropertyAccessor accessor) {
        return accessor.getSpecificTargetClasses() != null && accessor.getSpecificTargetClasses().length > 0;
    }
}

