/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.converter;

import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.converter.ConversionException;
import io.streamthoughts.kafka.connect.filepulse.expression.converter.PropertyConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class Converters {
    public static <T> T converts(List<PropertyConverter> converters, Object object, Class<T> classType) throws ConversionException {
        List<PropertyConverter> resolved = Converters.resolves(converters, object, classType);
        if (resolved.isEmpty()) {
            Object objectToConvert;
            if (object == null) {
                return null;
            }
            Object object2 = objectToConvert = object.getClass().equals(TypedValue.class) ? ((TypedValue)object).value() : object;
            if (classType.isAssignableFrom(objectToConvert.getClass())) {
                return (T)objectToConvert;
            }
            throw new ConversionException(String.format("Cannot found any property converter for type '%s' and object %s", classType.getCanonicalName(), object.getClass().getCanonicalName()));
        }
        Iterator<PropertyConverter> it = resolved.iterator();
        T converted = null;
        while (it.hasNext() && converted == null) {
            PropertyConverter converter = it.next();
            converted = converter.convert(object, classType);
        }
        return converted;
    }

    private static List<PropertyConverter> resolves(List<PropertyConverter> converters, Object object, Class<?> classType) {
        List<PropertyConverter> specificConverters = Converters.findSpecificConverterToConvert(converters, object, classType);
        if (!specificConverters.isEmpty()) {
            return specificConverters;
        }
        List<PropertyConverter> genericConverters = Converters.findGenericConverterToRead(converters, object, classType);
        if (!genericConverters.isEmpty()) {
            return genericConverters;
        }
        return Collections.emptyList();
    }

    private static List<PropertyConverter> findGenericConverterToRead(List<PropertyConverter> converters, Object object, Class<?> classType) {
        return converters.stream().filter(converter -> !Converters.isSpecificConverter(converter)).filter(converter -> converter.canConvert(object, classType)).collect(Collectors.toList());
    }

    private static List<PropertyConverter> findSpecificConverterToConvert(List<PropertyConverter> converters, Object object, Class<?> classType) {
        return converters.stream().filter(converter -> Converters.isConverterSpecificForType(classType, converter)).filter(converter -> converter.canConvert(object, classType)).collect(Collectors.toList());
    }

    private static boolean isConverterSpecificForType(Class<?> type, PropertyConverter converter) {
        if (Converters.isSpecificConverter(converter)) {
            Class<?>[] specificTargetClasses = converter.getSpecificTargetClasses();
            List l = Arrays.stream(specificTargetClasses).filter(clazz -> clazz.isAssignableFrom(type)).collect(Collectors.toList());
            return l.size() > 0;
        }
        return false;
    }

    private static boolean isSpecificConverter(PropertyConverter converter) {
        return converter.getSpecificTargetClasses() != null && converter.getSpecificTargetClasses().length > 0;
    }
}

