/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.converter;

import io.streamthoughts.kafka.connect.filepulse.data.Type;
import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.converter.ConversionException;
import io.streamthoughts.kafka.connect.filepulse.expression.converter.PropertyConverter;

public class PrimitiveConverter
implements PropertyConverter {
    @Override
    public boolean canConvert(Object o, Class<?> classType) {
        return Type.forClass(classType) != null;
    }

    @Override
    public <T> T convert(Object o, Class<T> classType) {
        Type type = Type.forClass(classType);
        if (type == null) {
            throw new ConversionException(String.format("Cannot convert object of type '%s' into expected type '%s'", o.getClass().getCanonicalName(), classType.getCanonicalName()));
        }
        if (o instanceof TypedValue) {
            TypedValue typed = (TypedValue)o;
            if (typed.type() == type) {
                return (T)typed.value();
            }
            return (T)type.convert(typed.value());
        }
        return (T)type.convert(o);
    }
}

